/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.glassfish.grizzly.Grizzly;

public class SSLContextConfigurator {
    public static final String TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    public static final String KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    public static final String TRUST_STORE_FILE = "javax.net.ssl.trustStore";
    public static final String KEY_STORE_FILE = "javax.net.ssl.keyStore";
    public static final String TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String KEY_FACTORY_MANAGER_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String TRUST_FACTORY_MANAGER_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    private static final Logger LOGGER = Grizzly.logger(SSLContextConfigurator.class);
    public static final SSLContextConfigurator DEFAULT_CONFIG = new SSLContextConfigurator();
    private String trustStoreProvider;
    private String keyStoreProvider;
    private String trustStoreType;
    private String keyStoreType;
    private char[] trustStorePass;
    private char[] keyStorePass;
    private char[] keyPass;
    private String trustStoreFile;
    private String keyStoreFile;
    private byte[] trustStoreBytes;
    private byte[] keyStoreBytes;
    private String trustManagerFactoryAlgorithm;
    private String keyManagerFactoryAlgorithm;
    private String securityProtocol = "TLS";

    public SSLContextConfigurator() {
        this(true);
    }

    public SSLContextConfigurator(boolean readSystemProperties) {
        if (readSystemProperties) {
            this.retrieve(System.getProperties());
        }
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass.toCharArray();
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass.toCharArray();
    }

    public void setKeyStorePass(char[] keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass.toCharArray();
    }

    public void setKeyPass(char[] keyPass) {
        this.keyPass = keyPass;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        this.trustStoreBytes = null;
    }

    public void setTrustStoreBytes(byte[] trustStoreBytes) {
        this.trustStoreBytes = trustStoreBytes;
        this.trustStoreFile = null;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        this.keyStoreBytes = null;
    }

    public void setKeyStoreBytes(byte[] keyStoreBytes) {
        this.keyStoreBytes = keyStoreBytes;
        this.keyStoreFile = null;
    }

    public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    @Deprecated
    public boolean validateConfiguration() {
        return this.validateConfiguration(false);
    }

    @Deprecated
    public boolean validateConfiguration(boolean needsKeyStore) {
        boolean valid = true;
        if (this.keyStoreBytes != null || this.keyStoreFile != null) {
            try {
                KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                SSLContextConfigurator.loadBytes(this.keyStoreBytes, this.keyStoreFile, this.keyStorePass, keyStore);
                String kmfAlgorithm = this.keyManagerFactoryAlgorithm;
                if (kmfAlgorithm == null) {
                    kmfAlgorithm = System.getProperty(KEY_FACTORY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                keyManagerFactory.init(keyStore, this.keyPass != null ? this.keyPass : this.keyStorePass);
            }
            catch (KeyStoreException e2) {
                LOGGER.log(Level.FINE, "Error initializing key store", e2);
                valid = false;
            }
            catch (CertificateException e3) {
                LOGGER.log(Level.FINE, "Key store certificate exception.", e3);
                valid = false;
            }
            catch (UnrecoverableKeyException e4) {
                LOGGER.log(Level.FINE, "Key store unrecoverable exception.", e4);
                valid = false;
            }
            catch (FileNotFoundException e5) {
                LOGGER.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e5);
                valid = false;
            }
            catch (IOException e6) {
                LOGGER.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e6);
                valid = false;
            }
            catch (NoSuchAlgorithmException e7) {
                LOGGER.log(Level.FINE, "Error initializing key manager factory (no such algorithm)", e7);
                valid = false;
            }
            catch (NoSuchProviderException e8) {
                LOGGER.log(Level.FINE, "Error initializing key store (no such provider)", e8);
                valid = false;
            }
        } else {
            boolean bl2 = valid = !needsKeyStore;
        }
        if (this.trustStoreBytes != null || this.trustStoreFile != null) {
            try {
                KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                SSLContextConfigurator.loadBytes(this.trustStoreBytes, this.trustStoreFile, this.trustStorePass, trustStore);
                String tmfAlgorithm = this.trustManagerFactoryAlgorithm;
                if (tmfAlgorithm == null) {
                    tmfAlgorithm = System.getProperty(TRUST_FACTORY_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                trustManagerFactory.init(trustStore);
            }
            catch (KeyStoreException e9) {
                LOGGER.log(Level.FINE, "Error initializing trust store", e9);
                valid = false;
            }
            catch (CertificateException e10) {
                LOGGER.log(Level.FINE, "Trust store certificate exception.", e10);
                valid = false;
            }
            catch (FileNotFoundException e11) {
                LOGGER.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e11);
                valid = false;
            }
            catch (IOException e12) {
                LOGGER.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e12);
                valid = false;
            }
            catch (NoSuchAlgorithmException e13) {
                LOGGER.log(Level.FINE, "Error initializing trust manager factory (no such algorithm)", e13);
                valid = false;
            }
            catch (NoSuchProviderException e14) {
                LOGGER.log(Level.FINE, "Error initializing trust store (no such provider)", e14);
                valid = false;
            }
        }
        return valid;
    }

    @Deprecated
    public SSLContext createSSLContext() {
        return this.createSSLContext(false);
    }

    public SSLContext createSSLContext(boolean throwException) {
        SSLContext sslContext;
        block36: {
            sslContext = null;
            try {
                KeyManagerFactory keyManagerFactory;
                TrustManagerFactory trustManagerFactory;
                block35: {
                    trustManagerFactory = null;
                    keyManagerFactory = null;
                    if (this.keyStoreBytes != null || this.keyStoreFile != null) {
                        try {
                            KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                            SSLContextConfigurator.loadBytes(this.keyStoreBytes, this.keyStoreFile, this.keyStorePass, keyStore);
                            String kmfAlgorithm = this.keyManagerFactoryAlgorithm;
                            if (kmfAlgorithm == null) {
                                kmfAlgorithm = System.getProperty(KEY_FACTORY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
                            }
                            keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                            keyManagerFactory.init(keyStore, this.keyPass != null ? this.keyPass : this.keyStorePass);
                        }
                        catch (KeyStoreException e2) {
                            LOGGER.log(Level.FINE, "Error initializing key store", e2);
                            if (throwException) {
                                throw new GenericStoreException(e2);
                            }
                        }
                        catch (CertificateException e3) {
                            LOGGER.log(Level.FINE, "Key store certificate exception.", e3);
                            if (throwException) {
                                throw new GenericStoreException(e3);
                            }
                        }
                        catch (UnrecoverableKeyException e4) {
                            LOGGER.log(Level.FINE, "Key store unrecoverable exception.", e4);
                            if (throwException) {
                                throw new GenericStoreException(e4);
                            }
                        }
                        catch (FileNotFoundException e5) {
                            LOGGER.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e5);
                            if (throwException) {
                                throw new GenericStoreException(e5);
                            }
                        }
                        catch (IOException e6) {
                            LOGGER.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e6);
                            if (throwException) {
                                throw new GenericStoreException(e6);
                            }
                        }
                        catch (NoSuchAlgorithmException e7) {
                            LOGGER.log(Level.FINE, "Error initializing key manager factory (no such algorithm)", e7);
                            if (throwException) {
                                throw new GenericStoreException(e7);
                            }
                        }
                        catch (NoSuchProviderException e8) {
                            LOGGER.log(Level.FINE, "Error initializing key store (no such provider)", e8);
                        }
                    }
                    if (this.trustStoreBytes != null || this.trustStoreFile != null) {
                        try {
                            KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                            SSLContextConfigurator.loadBytes(this.trustStoreBytes, this.trustStoreFile, this.trustStorePass, trustStore);
                            String tmfAlgorithm = this.trustManagerFactoryAlgorithm;
                            if (tmfAlgorithm == null) {
                                tmfAlgorithm = System.getProperty(TRUST_FACTORY_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
                            }
                            trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                            trustManagerFactory.init(trustStore);
                        }
                        catch (KeyStoreException e9) {
                            LOGGER.log(Level.FINE, "Error initializing trust store", e9);
                            if (throwException) {
                                throw new GenericStoreException(e9);
                            }
                        }
                        catch (CertificateException e10) {
                            LOGGER.log(Level.FINE, "Trust store certificate exception.", e10);
                            if (throwException) {
                                throw new GenericStoreException(e10);
                            }
                        }
                        catch (FileNotFoundException e11) {
                            LOGGER.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e11);
                            if (throwException) {
                                throw new GenericStoreException(e11);
                            }
                        }
                        catch (IOException e12) {
                            LOGGER.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e12);
                            if (throwException) {
                                throw new GenericStoreException(e12);
                            }
                        }
                        catch (NoSuchAlgorithmException e13) {
                            LOGGER.log(Level.FINE, "Error initializing trust manager factory (no such algorithm)", e13);
                            if (throwException) {
                                throw new GenericStoreException(e13);
                            }
                        }
                        catch (NoSuchProviderException e14) {
                            LOGGER.log(Level.FINE, "Error initializing trust store (no such provider)", e14);
                            if (!throwException) break block35;
                            throw new GenericStoreException(e14);
                        }
                    }
                }
                String secProtocol = "TLS";
                if (this.securityProtocol != null) {
                    secProtocol = this.securityProtocol;
                }
                sslContext = SSLContext.getInstance(secProtocol);
                sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
            }
            catch (KeyManagementException e15) {
                LOGGER.log(Level.FINE, "Key management error.", e15);
                if (throwException) {
                    throw new GenericStoreException(e15);
                }
            }
            catch (NoSuchAlgorithmException e16) {
                LOGGER.log(Level.FINE, "Error initializing algorithm.", e16);
                if (!throwException) break block36;
                throw new GenericStoreException(e16);
            }
        }
        return sslContext;
    }

    public void retrieve(Properties props) {
        this.trustStoreProvider = props.getProperty(TRUST_STORE_PROVIDER);
        this.keyStoreProvider = props.getProperty(KEY_STORE_PROVIDER);
        this.trustStoreType = props.getProperty(TRUST_STORE_TYPE);
        this.keyStoreType = props.getProperty(KEY_STORE_TYPE);
        this.trustStorePass = (char[])(props.getProperty(TRUST_STORE_PASSWORD) != null ? props.getProperty(TRUST_STORE_PASSWORD).toCharArray() : null);
        this.keyStorePass = (char[])(props.getProperty(KEY_STORE_PASSWORD) != null ? props.getProperty(KEY_STORE_PASSWORD).toCharArray() : null);
        this.trustStoreFile = props.getProperty(TRUST_STORE_FILE);
        this.keyStoreFile = props.getProperty(KEY_STORE_FILE);
        this.trustStoreBytes = null;
        this.keyStoreBytes = null;
        this.securityProtocol = "TLS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBytes(byte[] bytes, String storeFile, char[] password, KeyStore store) throws IOException, CertificateException, NoSuchAlgorithmException {
        InputStream inputStream2 = null;
        try {
            if (bytes != null) {
                inputStream2 = new ByteArrayInputStream(bytes);
            } else if (!"NONE".equals(storeFile)) {
                inputStream2 = new FileInputStream(storeFile);
            }
            store.load(inputStream2, password);
        }
        finally {
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static final class GenericStoreException
    extends RuntimeException {
        public GenericStoreException(Throwable cause) {
            super(cause);
        }
    }
}

