/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractReader;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;

public abstract class AbstractNIOAsyncQueueReader
extends AbstractReader<SocketAddress>
implements AsyncQueueReader<SocketAddress> {
    private static final Logger LOGGER = Grizzly.logger(AbstractNIOAsyncQueueReader.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int defaultBufferSize = 8192;
    protected final NIOTransport transport;
    private EOFException cachedEOFException;

    public AbstractNIOAsyncQueueReader(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public void read(Connection<SocketAddress> connection, Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor) {
        if (connection == null) {
            AbstractNIOAsyncQueueReader.failure(new IOException("Connection is null"), completionHandler);
            return;
        }
        if (!connection.isOpen()) {
            AbstractNIOAsyncQueueReader.failure(new IOException("Connection is closed"), completionHandler);
            return;
        }
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncReadQueue();
        AsyncReadQueueRecord queueRecord = AsyncReadQueueRecord.create(connection, buffer, completionHandler, interceptor);
        ReadResult currentResult = queueRecord.getCurrentResult();
        boolean isCurrent = connectionQueue.reserveSpace(1) == 1;
        try {
            if (isCurrent) {
                this.doRead(connection, queueRecord);
                int interceptInstructions = this.intercept(1, queueRecord, currentResult);
                if ((interceptInstructions & 1) != 0 || interceptor == null && queueRecord.isFinished()) {
                    boolean isQueueEmpty = connectionQueue.releaseSpaceAndNotify(1) == 0;
                    queueRecord.notifyComplete();
                    if (!isQueueEmpty) {
                        this.onReadyToRead(connection);
                    }
                    this.intercept(2, queueRecord, null);
                    queueRecord.recycle();
                } else {
                    if ((interceptInstructions & 4) != 0) {
                        currentResult.setMessage(null);
                        currentResult.setReadSize(0);
                        queueRecord.setMessage(null);
                    }
                    connectionQueue.setCurrentElement(queueRecord);
                    queueRecord.notifyIncomplete();
                    this.onReadyToRead(connection);
                    this.intercept(3, queueRecord, null);
                }
            } else {
                connectionQueue.offer(queueRecord);
                if (!connection.isOpen() && connectionQueue.remove(queueRecord)) {
                    this.onReadFailure(connection, queueRecord, new EOFException("Connection is closed"));
                }
            }
        }
        catch (IOException e2) {
            this.onReadFailure(connection, queueRecord, e2);
        }
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncReadQueue();
        return connectionQueue != null && !connectionQueue.isEmpty();
    }

    @Override
    public AsyncQueue.AsyncResult processAsync(Context context) {
        NIOConnection nioConnection = (NIOConnection)context.getConnection();
        if (!nioConnection.isOpen()) {
            return AsyncQueue.AsyncResult.COMPLETE;
        }
        TaskQueue<AsyncReadQueueRecord> connectionQueue = nioConnection.getAsyncReadQueue();
        boolean done = false;
        AsyncReadQueueRecord queueRecord = null;
        try {
            while ((queueRecord = connectionQueue.poll()) != null) {
                ReadResult currentResult = queueRecord.getCurrentResult();
                this.doRead(nioConnection, queueRecord);
                Interceptor interceptor = queueRecord.getInterceptor();
                int interceptInstructions = this.intercept(1, queueRecord, currentResult);
                if ((interceptInstructions & 1) != 0 || interceptor == null && queueRecord.isFinished()) {
                    if (!context.isManualIOEventControl() && connectionQueue.spaceInBytes() - 1 <= 0) {
                        context.setManualIOEventControl();
                    }
                    done = connectionQueue.releaseSpaceAndNotify(1) == 0;
                    queueRecord.notifyComplete();
                    this.intercept(2, queueRecord, null);
                    queueRecord.recycle();
                    if (!done) continue;
                    break;
                }
                if ((interceptInstructions & 4) != 0) {
                    currentResult.setMessage(null);
                    currentResult.setReadSize(0);
                    queueRecord.setMessage(null);
                }
                connectionQueue.setCurrentElement(queueRecord);
                queueRecord.notifyIncomplete();
                this.intercept(3, queueRecord, null);
                return AsyncQueue.AsyncResult.INCOMPLETE;
            }
            if (!done) {
                return AsyncQueue.AsyncResult.EXPECTING_MORE;
            }
        }
        catch (IOException e2) {
            this.onReadFailure(nioConnection, queueRecord, e2);
        }
        catch (Exception e3) {
            String message = "Unexpected exception occurred in AsyncQueueReader";
            LOGGER.log(Level.SEVERE, message, e3);
            IOException ioe = new IOException(e3.getClass() + ": " + message);
            this.onReadFailure(nioConnection, queueRecord, ioe);
        }
        return AsyncQueue.AsyncResult.COMPLETE;
    }

    @Override
    public void onClose(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncReadQueueRecord> readQueue = nioConnection.getAsyncReadQueue();
        if (!readQueue.isEmpty()) {
            AsyncReadQueueRecord record;
            EOFException error = this.cachedEOFException;
            if (error == null) {
                this.cachedEOFException = error = new EOFException("Connection closed");
            }
            while ((record = readQueue.poll()) != null) {
                record.notifyFailure(error);
            }
        }
    }

    @Override
    public final void close() {
    }

    protected final int doRead(Connection connection, AsyncReadQueueRecord queueRecord) throws IOException {
        ReadResult currentResult;
        Object message = queueRecord.getMessage();
        Buffer buffer = (Buffer)message;
        int readBytes = this.read0(connection, buffer, currentResult = queueRecord.getCurrentResult());
        if (readBytes == -1) {
            throw new EOFException();
        }
        return readBytes;
    }

    protected final void onReadFailure(Connection connection, AsyncReadQueueRecord failedRecord, IOException e2) {
        if (failedRecord != null) {
            failedRecord.notifyFailure(e2);
        }
        connection.closeSilently();
    }

    private static void failure(Throwable failure, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler) {
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
    }

    private int intercept(int event, AsyncReadQueueRecord asyncQueueRecord, ReadResult currentResult) {
        Interceptor interceptor = asyncQueueRecord.getInterceptor();
        if (interceptor != null) {
            return interceptor.intercept(event, asyncQueueRecord, currentResult);
        }
        return 0;
    }

    protected abstract int read0(Connection var1, Buffer var2, ReadResult<Buffer, SocketAddress> var3) throws IOException;

    protected abstract void onReadyToRead(Connection var1) throws IOException;
}

