/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.IntermediateInputStream;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.grizzly.http.util.ReadConverter;
import org.glassfish.grizzly.utils.Charsets;

public class B2CConverterBlocking {
    private static final Logger logger = Grizzly.logger(B2CConverterBlocking.class);
    private IntermediateInputStream iis;
    private ReadConverter conv;
    private String encoding;
    static final int BUFFER_SIZE = 8192;
    final char[] result = new char[8192];

    protected B2CConverterBlocking() {
    }

    public B2CConverterBlocking(String encoding) throws IOException {
        this.encoding = encoding;
        this.reset();
    }

    public void recycle() {
        this.conv.recycle();
    }

    public void convert(ByteChunk bb2, CharChunk cb2) throws IOException {
        this.convert(bb2, cb2, cb2.getBuffer().length - cb2.getEnd());
    }

    public void convert(ByteChunk bb2, CharChunk cb2, int limit) throws IOException {
        this.iis.setByteChunk(bb2);
        int debug = 0;
        try {
            while (limit > 0) {
                int size = limit < 8192 ? limit : 8192;
                int bbLengthBeforeRead = bb2.getLength();
                int cnt = this.conv.read(this.result, 0, size);
                if (cnt <= 0) {
                    if (debug > 0) {
                        this.log("EOF");
                    }
                    return;
                }
                if (debug > 1) {
                    this.log("Converted: " + new String(this.result, 0, cnt));
                }
                cb2.append(this.result, 0, cnt);
                limit -= bbLengthBeforeRead - bb2.getLength();
            }
        }
        catch (IOException ex2) {
            if (debug > 0) {
                this.log("Resetting the converter " + ex2.toString());
            }
            this.reset();
            throw ex2;
        }
    }

    public static void convertASCII(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc2 = mb.getByteChunk();
        CharChunk cc2 = mb.getCharChunk();
        int length = bc2.getLength();
        cc2.allocate(length, -1);
        byte[] bbuf = bc2.getBuffer();
        char[] cbuf = cc2.getBuffer();
        int start = bc2.getStart();
        for (int i2 = 0; i2 < length; ++i2) {
            cbuf[i2] = (char)(bbuf[i2 + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, length);
    }

    public void reset() throws IOException {
        this.iis = new IntermediateInputStream();
        this.conv = new ReadConverter(this.iis, Charsets.lookupCharset(this.encoding));
    }

    void log(String s2) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "B2CConverter: " + s2);
        }
    }
}

