/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;

public final class Ascii {
    private static final long INT_OVERFLOW_LIMIT = 0xCCCCCCCL;
    private static final long LONG_OVERFLOW_LIMIT = 0xCCCCCCCCCCCCCCCL;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static int toUpper(int c2) {
        return c2 >= 97 && c2 <= 122 ? c2 + 65 - 97 : c2 & 0xFF;
    }

    public static void toUpper(byte[] bytes) {
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int b2 = bytes[i2];
            bytes[i2] = (byte)(b2 >= 97 && b2 <= 122 ? b2 + 65 - 97 : b2);
        }
    }

    public static int toLower(int c2) {
        return c2 >= 65 && c2 <= 90 ? c2 - 65 + 97 : c2 & 0xFF;
    }

    public static void toLower(byte[] bytes) {
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int b2 = bytes[i2];
            bytes[i2] = (byte)(b2 >= 65 && b2 <= 90 ? b2 - 65 + 97 : b2);
        }
    }

    public static boolean isAlpha(int c2) {
        return c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90;
    }

    public static boolean isUpper(int c2) {
        return c2 >= 65 && c2 <= 90;
    }

    public static boolean isLower(int c2) {
        return c2 >= 97 && c2 <= 122;
    }

    public static boolean isWhite(int c2) {
        return c2 == 32 || c2 == 9 || c2 == 13 || c2 == 10 || c2 == 12 || c2 == 8;
    }

    public static boolean isDigit(int c2) {
        return c2 >= 48 && c2 <= 57;
    }

    public static int parseInt(DataChunk dataChunk) {
        switch (dataChunk.getType()) {
            case Buffer: {
                BufferChunk bc2 = dataChunk.getBufferChunk();
                return Ascii.parseInt(bc2.getBuffer(), bc2.getStart(), bc2.getLength());
            }
            case String: {
                return Integer.parseInt(dataChunk.toString());
            }
            case Chars: {
                CharChunk cc2 = dataChunk.getCharChunk();
                return Ascii.parseInt(cc2.getBuffer(), cc2.getStart(), cc2.getLength());
            }
        }
        throw new NullPointerException();
    }

    public static int parseInt(DataChunk dataChunk, int offset, int length) {
        switch (dataChunk.getType()) {
            case Buffer: {
                BufferChunk bc2 = dataChunk.getBufferChunk();
                return Ascii.parseInt(bc2.getBuffer(), bc2.getStart() + offset, length);
            }
            case String: {
                return Ascii.parseInt(dataChunk.toString(), offset, length);
            }
            case Chars: {
                CharChunk cc2 = dataChunk.getCharChunk();
                return Ascii.parseInt(cc2.getBuffer(), cc2.getStart() + offset, cc2.getLength());
            }
        }
        throw new NullPointerException();
    }

    public static int parseInt(byte[] b2, int off, int len) throws NumberFormatException {
        byte c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2[off++])) {
            throw new NumberFormatException();
        }
        int n2 = c2 - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c2 = b2[off++])) {
                throw new NumberFormatException();
            }
            n2 = n2 * 10 + c2 - 48;
        }
        return n2;
    }

    public static int parseInt(char[] b2, int off, int len) throws NumberFormatException {
        char c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2[off++])) {
            throw new NumberFormatException();
        }
        int n2 = c2 - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c2 = b2[off++])) {
                throw new NumberFormatException();
            }
            n2 = n2 * 10 + c2 - 48;
        }
        return n2;
    }

    public static int parseInt(Buffer b2, int off, int len) throws NumberFormatException {
        byte c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2.get(off++))) {
            throw new NumberFormatException();
        }
        int n2 = c2 - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c2 = b2.get(off++))) {
                throw new NumberFormatException();
            }
            n2 = n2 * 10 + c2 - 48;
        }
        return n2;
    }

    public static int parseInt(String s2, int off, int len) throws NumberFormatException {
        char c2;
        if (s2 == null || len <= 0 || !Ascii.isDigit(c2 = s2.charAt(off++))) {
            throw new NumberFormatException();
        }
        int n2 = c2 - 48;
        while (--len > 0) {
            if (Ascii.isDigit(c2 = s2.charAt(off++)) && ((long)n2 < 0xCCCCCCCL || (long)n2 == 0xCCCCCCCL && c2 - 48 < 8)) {
                n2 = n2 * 10 + c2 - 48;
                continue;
            }
            throw new NumberFormatException();
        }
        return n2;
    }

    public static long parseLong(byte[] b2, int off, int len) throws NumberFormatException {
        byte c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2[off++])) {
            throw new NumberFormatException();
        }
        long n2 = c2 - 48;
        while (--len > 0) {
            if (Ascii.isDigit(c2 = b2[off++]) && (n2 < 0xCCCCCCCCCCCCCCCL || n2 == 0xCCCCCCCCCCCCCCCL && c2 - 48 < 8)) {
                n2 = n2 * 10L + (long)c2 - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return n2;
    }

    public static long parseLong(char[] b2, int off, int len) throws NumberFormatException {
        char c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2[off++])) {
            throw new NumberFormatException();
        }
        long n2 = c2 - 48;
        while (--len > 0) {
            if (Ascii.isDigit(c2 = b2[off++]) && (n2 < 0xCCCCCCCCCCCCCCCL || n2 == 0xCCCCCCCCCCCCCCCL && c2 - 48 < 8)) {
                n2 = n2 * 10L + (long)c2 - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return n2;
    }

    public static long parseLong(String s2, int off, int len) throws NumberFormatException {
        char c2;
        if (s2 == null || len <= 0 || !Ascii.isDigit(c2 = s2.charAt(off++))) {
            throw new NumberFormatException();
        }
        long n2 = c2 - 48;
        while (--len > 0) {
            if (Ascii.isDigit(c2 = s2.charAt(off++)) && (n2 < 0xCCCCCCCCCCCCCCCL || n2 == 0xCCCCCCCCCCCCCCCL && c2 - 48 < 8)) {
                n2 = n2 * 10L + (long)c2 - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return n2;
    }

    public static long parseLong(Buffer b2, int off, int len) throws NumberFormatException {
        byte c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2.get(off++))) {
            throw new NumberFormatException();
        }
        long n2 = c2 - 48;
        while (--len > 0) {
            if (Ascii.isDigit(c2 = b2.get(off++)) && (n2 < 0xCCCCCCCCCCCCCCCL || n2 == 0xCCCCCCCCCCCCCCCL && c2 - 48 < 8)) {
                n2 = n2 * 10L + (long)c2 - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return n2;
    }

    public static long parseLong(DataChunk dataChunk) {
        switch (dataChunk.getType()) {
            case Buffer: {
                BufferChunk bc2 = dataChunk.getBufferChunk();
                return Ascii.parseLong(bc2.getBuffer(), bc2.getStart(), bc2.getLength());
            }
            case String: {
                return Long.parseLong(dataChunk.toString());
            }
            case Chars: {
                CharChunk cc2 = dataChunk.getCharChunk();
                return Ascii.parseLong(cc2.getBuffer(), cc2.getStart(), cc2.getLength());
            }
        }
        throw new NullPointerException();
    }

    public static long parseLong(DataChunk dataChunk, int offset, int length) {
        switch (dataChunk.getType()) {
            case Buffer: {
                BufferChunk bc2 = dataChunk.getBufferChunk();
                return Ascii.parseLong(bc2.getBuffer(), bc2.getStart() + offset, length);
            }
            case String: {
                return Ascii.parseLong(dataChunk.toString(), offset, length);
            }
            case Chars: {
                CharChunk cc2 = dataChunk.getCharChunk();
                return Ascii.parseLong(cc2.getBuffer(), cc2.getStart() + offset, cc2.getLength());
            }
        }
        throw new NullPointerException();
    }

    public static void intToHexString(Buffer buffer, int i2) {
        Ascii.intToUnsignedString(buffer, i2, 4);
    }

    public static void intToUnsignedString(Buffer buffer, int value, int shift) {
        if (value == 0) {
            buffer.put((byte)48);
            return;
        }
        int currentShift = 32 - shift;
        int radix = 1 << shift;
        int mask = radix - 1 << currentShift;
        boolean initialZeros = true;
        while (mask != 0) {
            int digit = (value & mask) >>> currentShift;
            if (digit != 0 || !initialZeros) {
                buffer.put((byte)digits[digit]);
                initialZeros = false;
            }
            mask >>>= shift;
            currentShift -= shift;
        }
    }
}

