/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.compression.lzma.impl.rangecoder;

import java.io.IOException;
import org.glassfish.grizzly.compression.lzma.impl.rangecoder.RangeDecoder;
import org.glassfish.grizzly.compression.lzma.impl.rangecoder.RangeEncoder;

public class BitTreeEncoder {
    final short[] Models;
    final int NumBitLevels;

    public BitTreeEncoder(int numBitLevels) {
        this.NumBitLevels = numBitLevels;
        this.Models = new short[1 << numBitLevels];
    }

    public void init() {
        RangeDecoder.initBitModels(this.Models);
    }

    public void encode(RangeEncoder rangeEncoder, int symbol) throws IOException {
        int m3 = 1;
        int bitIndex = this.NumBitLevels;
        while (bitIndex != 0) {
            int bit = symbol >>> --bitIndex & 1;
            rangeEncoder.encode(this.Models, m3, bit);
            m3 = m3 << 1 | bit;
        }
    }

    public void reverseEncode(RangeEncoder rangeEncoder, int symbol) throws IOException {
        int m3 = 1;
        for (int i2 = 0; i2 < this.NumBitLevels; ++i2) {
            int bit = symbol & 1;
            rangeEncoder.encode(this.Models, m3, bit);
            m3 = m3 << 1 | bit;
            symbol >>= 1;
        }
    }

    public int getPrice(int symbol) {
        int price = 0;
        int m3 = 1;
        int bitIndex = this.NumBitLevels;
        while (bitIndex != 0) {
            int bit = symbol >>> --bitIndex & 1;
            price += RangeEncoder.getPrice(this.Models[m3], bit);
            m3 = (m3 << 1) + bit;
        }
        return price;
    }

    public int reverseGetPrice(int symbol) {
        int price = 0;
        int m3 = 1;
        for (int i2 = this.NumBitLevels; i2 != 0; --i2) {
            int bit = symbol & 1;
            symbol >>>= 1;
            price += RangeEncoder.getPrice(this.Models[m3], bit);
            m3 = m3 << 1 | bit;
        }
        return price;
    }

    public static int reverseGetPrice(short[] Models, int startIndex, int NumBitLevels, int symbol) {
        int price = 0;
        int m3 = 1;
        for (int i2 = NumBitLevels; i2 != 0; --i2) {
            int bit = symbol & 1;
            symbol >>>= 1;
            price += RangeEncoder.getPrice(Models[startIndex + m3], bit);
            m3 = m3 << 1 | bit;
        }
        return price;
    }

    public static void reverseEncode(short[] Models, int startIndex, RangeEncoder rangeEncoder, int NumBitLevels, int symbol) throws IOException {
        int m3 = 1;
        for (int i2 = 0; i2 < NumBitLevels; ++i2) {
            int bit = symbol & 1;
            rangeEncoder.encode(Models, startIndex + m3, bit);
            m3 = m3 << 1 | bit;
            symbol >>= 1;
        }
    }
}

