/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import org.apache.logging.log4j.core.config.ConfigurationSource;

public class Source {
    private final File file;
    private final URI uri;
    private final String location;

    public Source(ConfigurationSource source2) {
        this.file = source2.getFile();
        this.uri = source2.getURI();
        this.location = source2.getLocation();
    }

    public Source(File file) {
        this.file = Objects.requireNonNull(file, "file is null");
        this.location = file.getAbsolutePath();
        this.uri = null;
    }

    public Source(URI uri, long lastModified) {
        this.uri = Objects.requireNonNull(uri, "URI is null");
        this.location = uri.toString();
        this.file = null;
    }

    public File getFile() {
        return this.file;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Source)) {
            return false;
        }
        Source source2 = (Source)o2;
        return Objects.equals(this.location, source2.location);
    }

    public int hashCode() {
        return 31 + Objects.hashCode(this.location);
    }
}

