/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.util.StringMap;

public class ContextDataDeserializer
extends StdDeserializer<StringMap> {
    private static final long serialVersionUID = 1L;

    ContextDataDeserializer() {
        super(Map.class);
    }

    @Override
    public StringMap deserialize(JsonParser jp2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        StringMap contextData = ContextDataFactory.createContextData();
        while (jp2.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp2.getCurrentName();
            jp2.nextToken();
            contextData.putValue(fieldName, jp2.getText());
        }
        return contextData;
    }
}

