/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class PropertiesStringLookup
extends AbstractStringLookup {
    static final PropertiesStringLookup INSTANCE = new PropertiesStringLookup();
    static final String SEPARATOR = "::";

    static String toPropertyKey(String file, String key) {
        return AbstractStringLookup.toLookupKey(file, SEPARATOR, key);
    }

    private PropertiesStringLookup() {
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        String[] keys2 = key.split(SEPARATOR);
        int keyLen = keys2.length;
        if (keyLen < 2) {
            throw IllegalArgumentExceptions.format("Bad properties key format [%s]; expected format is %s.", key, PropertiesStringLookup.toPropertyKey("DocumentPath", "Key"));
        }
        String documentPath = keys2[0];
        String propertyKey = StringUtils.substringAfter(key, SEPARATOR);
        try {
            Properties properties = new Properties();
            try (InputStream inputStream2 = Files.newInputStream(Paths.get(documentPath, new String[0]), new OpenOption[0]);){
                properties.load(inputStream2);
            }
            return properties.getProperty(propertyKey);
        }
        catch (Exception e2) {
            throw IllegalArgumentExceptions.format(e2, "Error looking up properties [%s] and key [%s].", documentPath, propertyKey);
        }
    }
}

