/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.Arrays;
import org.antlr.v4.runtime.atn.PredictionContext;
import org.antlr.v4.runtime.atn.SingletonPredictionContext;

public class ArrayPredictionContext
extends PredictionContext {
    public final PredictionContext[] parents;
    public final int[] returnStates;

    public ArrayPredictionContext(SingletonPredictionContext a2) {
        this(new PredictionContext[]{a2.parent}, new int[]{a2.returnState});
    }

    public ArrayPredictionContext(PredictionContext[] parents, int[] returnStates) {
        super(ArrayPredictionContext.calculateHashCode(parents, returnStates));
        assert (parents != null && parents.length > 0);
        assert (returnStates != null && returnStates.length > 0);
        this.parents = parents;
        this.returnStates = returnStates;
    }

    @Override
    public boolean isEmpty() {
        return this.returnStates[0] == Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.returnStates.length;
    }

    @Override
    public PredictionContext getParent(int index) {
        return this.parents[index];
    }

    @Override
    public int getReturnState(int index) {
        return this.returnStates[index];
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ArrayPredictionContext)) {
            return false;
        }
        if (this.hashCode() != o2.hashCode()) {
            return false;
        }
        ArrayPredictionContext a2 = (ArrayPredictionContext)o2;
        return Arrays.equals(this.returnStates, a2.returnStates) && Arrays.equals(this.parents, a2.parents);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i2 = 0; i2 < this.returnStates.length; ++i2) {
            if (i2 > 0) {
                buf.append(", ");
            }
            if (this.returnStates[i2] == Integer.MAX_VALUE) {
                buf.append("$");
                continue;
            }
            buf.append(this.returnStates[i2]);
            if (this.parents[i2] != null) {
                buf.append(' ');
                buf.append(this.parents[i2].toString());
                continue;
            }
            buf.append("null");
        }
        buf.append("]");
        return buf.toString();
    }
}

