/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;

public class TokenStreamRewriter {
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    public static final int MIN_TOKEN_INDEX = 0;
    protected final TokenStream tokens;
    protected final Map<String, List<RewriteOperation>> programs;
    protected final Map<String, Integer> lastRewriteTokenIndexes;

    public TokenStreamRewriter(TokenStream tokens) {
        this.tokens = tokens;
        this.programs = new HashMap<String, List<RewriteOperation>>();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap<String, Integer>();
    }

    public final TokenStream getTokenStream() {
        return this.tokens;
    }

    public void rollback(int instructionIndex) {
        this.rollback(DEFAULT_PROGRAM_NAME, instructionIndex);
    }

    public void rollback(String programName, int instructionIndex) {
        List<RewriteOperation> is2 = this.programs.get(programName);
        if (is2 != null) {
            this.programs.put(programName, is2.subList(0, instructionIndex));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String programName) {
        this.rollback(programName, 0);
    }

    public void insertAfter(Token t2, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, t2, text);
    }

    public void insertAfter(int index, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertAfter(String programName, Token t2, Object text) {
        this.insertAfter(programName, t2.getTokenIndex(), text);
    }

    public void insertAfter(String programName, int index, Object text) {
        InsertAfterOp op = new InsertAfterOp(index, text);
        List<RewriteOperation> rewrites = this.getProgram(programName);
        op.instructionIndex = rewrites.size();
        rewrites.add(op);
    }

    public void insertBefore(Token t2, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, t2, text);
    }

    public void insertBefore(int index, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertBefore(String programName, Token t2, Object text) {
        this.insertBefore(programName, t2.getTokenIndex(), text);
    }

    public void insertBefore(String programName, int index, Object text) {
        InsertBeforeOp op = new InsertBeforeOp(index, text);
        List<RewriteOperation> rewrites = this.getProgram(programName);
        op.instructionIndex = rewrites.size();
        rewrites.add(op);
    }

    public void replace(int index, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, index, index, text);
    }

    public void replace(int from, int to, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to, text);
    }

    public void replace(Token indexT, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, indexT, indexT, text);
    }

    public void replace(Token from, Token to, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to, text);
    }

    public void replace(String programName, int from, int to, Object text) {
        if (from > to || from < 0 || to < 0 || to >= this.tokens.size()) {
            throw new IllegalArgumentException("replace: range invalid: " + from + ".." + to + "(size=" + this.tokens.size() + ")");
        }
        ReplaceOp op = new ReplaceOp(from, to, text);
        List<RewriteOperation> rewrites = this.getProgram(programName);
        op.instructionIndex = rewrites.size();
        rewrites.add(op);
    }

    public void replace(String programName, Token from, Token to, Object text) {
        this.replace(programName, from.getTokenIndex(), to.getTokenIndex(), text);
    }

    public void delete(int index) {
        this.delete(DEFAULT_PROGRAM_NAME, index, index);
    }

    public void delete(int from, int to) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to);
    }

    public void delete(Token indexT) {
        this.delete(DEFAULT_PROGRAM_NAME, indexT, indexT);
    }

    public void delete(Token from, Token to) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to);
    }

    public void delete(String programName, int from, int to) {
        this.replace(programName, from, to, null);
    }

    public void delete(String programName, Token from, Token to) {
        this.replace(programName, from, to, null);
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String programName) {
        Integer I2 = this.lastRewriteTokenIndexes.get(programName);
        if (I2 == null) {
            return -1;
        }
        return I2;
    }

    protected void setLastRewriteTokenIndex(String programName, int i2) {
        this.lastRewriteTokenIndexes.put(programName, i2);
    }

    protected List<RewriteOperation> getProgram(String name) {
        List<RewriteOperation> is2 = this.programs.get(name);
        if (is2 == null) {
            is2 = this.initializeProgram(name);
        }
        return is2;
    }

    private List<RewriteOperation> initializeProgram(String name) {
        ArrayList<RewriteOperation> is2 = new ArrayList<RewriteOperation>(100);
        this.programs.put(name, is2);
        return is2;
    }

    public String getText() {
        return this.getText(DEFAULT_PROGRAM_NAME, Interval.of(0, this.tokens.size() - 1));
    }

    public String getText(String programName) {
        return this.getText(programName, Interval.of(0, this.tokens.size() - 1));
    }

    public String getText(Interval interval) {
        return this.getText(DEFAULT_PROGRAM_NAME, interval);
    }

    public String getText(String programName, Interval interval) {
        List<RewriteOperation> rewrites = this.programs.get(programName);
        int start = interval.a;
        int stop = interval.b;
        if (stop > this.tokens.size() - 1) {
            stop = this.tokens.size() - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (rewrites == null || rewrites.isEmpty()) {
            return this.tokens.getText(interval);
        }
        StringBuilder buf = new StringBuilder();
        Map<Integer, RewriteOperation> indexToOp = this.reduceToSingleOperationPerIndex(rewrites);
        int i2 = start;
        while (i2 <= stop && i2 < this.tokens.size()) {
            RewriteOperation op = indexToOp.get(i2);
            indexToOp.remove(i2);
            Token t2 = this.tokens.get(i2);
            if (op == null) {
                if (t2.getType() != -1) {
                    buf.append(t2.getText());
                }
                ++i2;
                continue;
            }
            i2 = op.execute(buf);
        }
        if (stop == this.tokens.size() - 1) {
            for (RewriteOperation op : indexToOp.values()) {
                if (op.index < this.tokens.size() - 1) continue;
                buf.append(op.text);
            }
        }
        return buf.toString();
    }

    protected Map<Integer, RewriteOperation> reduceToSingleOperationPerIndex(List<RewriteOperation> rewrites) {
        List<ReplaceOp> prevReplaces;
        RewriteOperation op;
        int i2;
        for (i2 = 0; i2 < rewrites.size(); ++i2) {
            op = rewrites.get(i2);
            if (op == null || !(op instanceof ReplaceOp)) continue;
            ReplaceOp rop = (ReplaceOp)rewrites.get(i2);
            List<InsertBeforeOp> inserts = this.getKindOfOps(rewrites, InsertBeforeOp.class, i2);
            for (InsertBeforeOp iop : inserts) {
                if (iop.index == rop.index) {
                    rewrites.set(iop.instructionIndex, null);
                    rop.text = iop.text.toString() + (rop.text != null ? rop.text.toString() : "");
                    continue;
                }
                if (iop.index <= rop.index || iop.index > rop.lastIndex) continue;
                rewrites.set(iop.instructionIndex, null);
            }
            prevReplaces = this.getKindOfOps(rewrites, ReplaceOp.class, i2);
            for (ReplaceOp prevRop : prevReplaces) {
                boolean disjoint;
                if (prevRop.index >= rop.index && prevRop.lastIndex <= rop.lastIndex) {
                    rewrites.set(prevRop.instructionIndex, null);
                    continue;
                }
                boolean bl2 = disjoint = prevRop.lastIndex < rop.index || prevRop.index > rop.lastIndex;
                if (prevRop.text == null && rop.text == null && !disjoint) {
                    rewrites.set(prevRop.instructionIndex, null);
                    rop.index = Math.min(prevRop.index, rop.index);
                    rop.lastIndex = Math.max(prevRop.lastIndex, rop.lastIndex);
                    System.out.println("new rop " + rop);
                    continue;
                }
                if (disjoint) continue;
                throw new IllegalArgumentException("replace op boundaries of " + rop + " overlap with previous " + prevRop);
            }
        }
        for (i2 = 0; i2 < rewrites.size(); ++i2) {
            op = rewrites.get(i2);
            if (op == null || !(op instanceof InsertBeforeOp)) continue;
            InsertBeforeOp iop = (InsertBeforeOp)rewrites.get(i2);
            List<InsertBeforeOp> prevInserts = this.getKindOfOps(rewrites, InsertBeforeOp.class, i2);
            for (InsertBeforeOp prevIop : prevInserts) {
                if (prevIop.index != iop.index) continue;
                if (InsertAfterOp.class.isInstance(prevIop)) {
                    iop.text = this.catOpText(prevIop.text, iop.text);
                    rewrites.set(prevIop.instructionIndex, null);
                    continue;
                }
                if (!InsertBeforeOp.class.isInstance(prevIop)) continue;
                iop.text = this.catOpText(iop.text, prevIop.text);
                rewrites.set(prevIop.instructionIndex, null);
            }
            prevReplaces = this.getKindOfOps(rewrites, ReplaceOp.class, i2);
            for (ReplaceOp rop : prevReplaces) {
                if (iop.index == rop.index) {
                    rop.text = this.catOpText(iop.text, rop.text);
                    rewrites.set(i2, null);
                    continue;
                }
                if (iop.index < rop.index || iop.index > rop.lastIndex) continue;
                throw new IllegalArgumentException("insert op " + iop + " within boundaries of previous " + rop);
            }
        }
        HashMap<Integer, RewriteOperation> m3 = new HashMap<Integer, RewriteOperation>();
        for (int i3 = 0; i3 < rewrites.size(); ++i3) {
            RewriteOperation op2 = rewrites.get(i3);
            if (op2 == null) continue;
            if (m3.get(op2.index) != null) {
                throw new Error("should only be one op per index");
            }
            m3.put(op2.index, op2);
        }
        return m3;
    }

    protected String catOpText(Object a2, Object b2) {
        String x2 = "";
        String y2 = "";
        if (a2 != null) {
            x2 = a2.toString();
        }
        if (b2 != null) {
            y2 = b2.toString();
        }
        return x2 + y2;
    }

    protected <T extends RewriteOperation> List<? extends T> getKindOfOps(List<? extends RewriteOperation> rewrites, Class<T> kind, int before) {
        ArrayList<T> ops = new ArrayList<T>();
        for (int i2 = 0; i2 < before && i2 < rewrites.size(); ++i2) {
            RewriteOperation op = rewrites.get(i2);
            if (op == null || !kind.isInstance(op)) continue;
            ops.add(kind.cast(op));
        }
        return ops;
    }

    class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int from, int to, Object text) {
            super(from, text);
            this.lastIndex = to;
        }

        @Override
        public int execute(StringBuilder buf) {
            if (this.text != null) {
                buf.append(this.text);
            }
            return this.lastIndex + 1;
        }

        @Override
        public String toString() {
            if (this.text == null) {
                return "<DeleteOp@" + TokenStreamRewriter.this.tokens.get(this.index) + ".." + TokenStreamRewriter.this.tokens.get(this.lastIndex) + ">";
            }
            return "<ReplaceOp@" + TokenStreamRewriter.this.tokens.get(this.index) + ".." + TokenStreamRewriter.this.tokens.get(this.lastIndex) + ":\"" + this.text + "\">";
        }
    }

    class InsertAfterOp
    extends InsertBeforeOp {
        public InsertAfterOp(int index, Object text) {
            super(index + 1, text);
        }
    }

    class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int index, Object text) {
            super(index, text);
        }

        @Override
        public int execute(StringBuilder buf) {
            buf.append(this.text);
            if (TokenStreamRewriter.this.tokens.get(this.index).getType() != -1) {
                buf.append(TokenStreamRewriter.this.tokens.get(this.index).getText());
            }
            return this.index + 1;
        }
    }

    public class RewriteOperation {
        protected int instructionIndex;
        protected int index;
        protected Object text;

        protected RewriteOperation(int index) {
            this.index = index;
        }

        protected RewriteOperation(int index, Object text) {
            this.index = index;
            this.text = text;
        }

        public int execute(StringBuilder buf) {
            return this.index;
        }

        public String toString() {
            String opName = this.getClass().getName();
            int $index = opName.indexOf(36);
            opName = opName.substring($index + 1, opName.length());
            return "<" + opName + "@" + TokenStreamRewriter.this.tokens.get(this.index) + ":\"" + this.text + "\">";
        }
    }
}

