/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.plugin.AbstractPluginFactory;

public class ChangeFactory
extends AbstractPluginFactory<Change> {
    private Map<Class<? extends Change>, ChangeMetaData> metaDataByClass = new ConcurrentHashMap<Class<? extends Change>, ChangeMetaData>();

    private ChangeFactory() {
    }

    @Override
    protected Class<Change> getPluginClass() {
        return Change.class;
    }

    @Override
    protected int getPriority(Change obj, Object ... args2) {
        String commandName = (String)args2[0];
        ChangeMetaData changeMetaData = this.getChangeMetaData(obj);
        if (commandName.equals(changeMetaData.getName())) {
            return changeMetaData.getPriority();
        }
        return -1;
    }

    public ChangeMetaData getChangeMetaData(String change) {
        Change changeObj = this.create(change);
        if (changeObj == null) {
            return null;
        }
        return this.getChangeMetaData(changeObj);
    }

    public ChangeMetaData getChangeMetaData(Change change) {
        if (!this.metaDataByClass.containsKey(change.getClass())) {
            this.metaDataByClass.put(change.getClass(), change.createChangeMetaData());
        }
        return this.metaDataByClass.get(change.getClass());
    }

    public void unregister(String name) {
        for (Change change : new ArrayList(this.findAllInstances())) {
            if (!this.getChangeMetaData(change).getName().equals(name)) continue;
            this.removeInstance(change);
        }
    }

    public SortedSet<String> getDefinedChanges() {
        TreeSet<String> names = new TreeSet<String>();
        for (Change change : this.findAllInstances()) {
            names.add(this.getChangeMetaData(change).getName());
        }
        return Collections.unmodifiableSortedSet(names);
    }

    public Change create(String name) {
        Change plugin = (Change)this.getPlugin(name);
        if (plugin == null) {
            return null;
        }
        try {
            return (Change)plugin.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    public Map<String, Object> getParameters(Change change) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ChangeMetaData changeMetaData = this.getChangeMetaData(change);
        for (ChangeParameterMetaData param : changeMetaData.getParameters().values()) {
            Object currentValue = param.getCurrentValue(change);
            if (currentValue == null) continue;
            returnMap.put(param.getParameterName(), currentValue);
        }
        return returnMap;
    }

    public static ChangeFactory getInstance() {
        return Scope.getCurrentScope().getSingleton(ChangeFactory.class);
    }
}

