/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.PropUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.Header;
import javax.mail.MessagingException;

public class InternetHeaders {
    private static final boolean ignoreWhitespaceLines = PropUtil.getBooleanSystemProperty("mail.mime.ignorewhitespacelines", false);
    protected List<InternetHeader> headers = new ArrayList<InternetHeader>(40);

    public InternetHeaders() {
        this.headers.add(new InternetHeader("Return-Path", null));
        this.headers.add(new InternetHeader("Received", null));
        this.headers.add(new InternetHeader("Resent-Date", null));
        this.headers.add(new InternetHeader("Resent-From", null));
        this.headers.add(new InternetHeader("Resent-Sender", null));
        this.headers.add(new InternetHeader("Resent-To", null));
        this.headers.add(new InternetHeader("Resent-Cc", null));
        this.headers.add(new InternetHeader("Resent-Bcc", null));
        this.headers.add(new InternetHeader("Resent-Message-Id", null));
        this.headers.add(new InternetHeader("Date", null));
        this.headers.add(new InternetHeader("From", null));
        this.headers.add(new InternetHeader("Sender", null));
        this.headers.add(new InternetHeader("Reply-To", null));
        this.headers.add(new InternetHeader("To", null));
        this.headers.add(new InternetHeader("Cc", null));
        this.headers.add(new InternetHeader("Bcc", null));
        this.headers.add(new InternetHeader("Message-Id", null));
        this.headers.add(new InternetHeader("In-Reply-To", null));
        this.headers.add(new InternetHeader("References", null));
        this.headers.add(new InternetHeader("Subject", null));
        this.headers.add(new InternetHeader("Comments", null));
        this.headers.add(new InternetHeader("Keywords", null));
        this.headers.add(new InternetHeader("Errors-To", null));
        this.headers.add(new InternetHeader("MIME-Version", null));
        this.headers.add(new InternetHeader("Content-Type", null));
        this.headers.add(new InternetHeader("Content-Transfer-Encoding", null));
        this.headers.add(new InternetHeader("Content-MD5", null));
        this.headers.add(new InternetHeader(":", null));
        this.headers.add(new InternetHeader("Content-Length", null));
        this.headers.add(new InternetHeader("Status", null));
    }

    public InternetHeaders(InputStream is2) throws MessagingException {
        this(is2, false);
    }

    public InternetHeaders(InputStream is2, boolean allowutf8) throws MessagingException {
        this.load(is2, allowutf8);
    }

    public void load(InputStream is2) throws MessagingException {
        this.load(is2, false);
    }

    public void load(InputStream is2, boolean allowutf8) throws MessagingException {
        LineInputStream lis = new LineInputStream(is2, allowutf8);
        String prevline = null;
        StringBuilder lineBuffer = new StringBuilder();
        try {
            String line;
            boolean first = true;
            do {
                if ((line = lis.readLine()) != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    if (prevline != null) {
                        lineBuffer.append(prevline);
                        prevline = null;
                    }
                    if (first) {
                        String lt2 = line.trim();
                        if (lt2.length() > 0) {
                            lineBuffer.append(lt2);
                        }
                    } else {
                        if (lineBuffer.length() > 0) {
                            lineBuffer.append("\r\n");
                        }
                        lineBuffer.append(line);
                    }
                } else {
                    if (prevline != null) {
                        this.addHeaderLine(prevline);
                    } else if (lineBuffer.length() > 0) {
                        this.addHeaderLine(lineBuffer.toString());
                        lineBuffer.setLength(0);
                    }
                    prevline = line;
                }
                first = false;
            } while (line != null && !InternetHeaders.isEmpty(line));
        }
        catch (IOException ioex) {
            throw new MessagingException("Error in input stream", ioex);
        }
    }

    private static final boolean isEmpty(String line) {
        return line.length() == 0 || ignoreWhitespaceLines && line.trim().length() == 0;
    }

    public String[] getHeader(String name) {
        Iterator<InternetHeader> e2 = this.headers.iterator();
        ArrayList<String> v2 = new ArrayList<String>();
        while (e2.hasNext()) {
            InternetHeader h2 = e2.next();
            if (!name.equalsIgnoreCase(h2.getName()) || h2.line == null) continue;
            v2.add(h2.getValue());
        }
        if (v2.size() == 0) {
            return null;
        }
        String[] r2 = new String[v2.size()];
        r2 = v2.toArray(r2);
        return r2;
    }

    public String getHeader(String name, String delimiter) {
        String[] s2 = this.getHeader(name);
        if (s2 == null) {
            return null;
        }
        if (s2.length == 1 || delimiter == null) {
            return s2[0];
        }
        StringBuilder r2 = new StringBuilder(s2[0]);
        for (int i2 = 1; i2 < s2.length; ++i2) {
            r2.append(delimiter);
            r2.append(s2[i2]);
        }
        return r2.toString();
    }

    public void setHeader(String name, String value) {
        boolean found = false;
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            InternetHeader h2 = this.headers.get(i2);
            if (!name.equalsIgnoreCase(h2.getName())) continue;
            if (!found) {
                int j2;
                h2.line = h2.line != null && (j2 = h2.line.indexOf(58)) >= 0 ? h2.line.substring(0, j2 + 1) + " " + value : name + ": " + value;
                found = true;
                continue;
            }
            this.headers.remove(i2);
            --i2;
        }
        if (!found) {
            this.addHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        boolean addReverse;
        int pos = this.headers.size();
        boolean bl2 = addReverse = name.equalsIgnoreCase("Received") || name.equalsIgnoreCase("Return-Path");
        if (addReverse) {
            pos = 0;
        }
        for (int i2 = this.headers.size() - 1; i2 >= 0; --i2) {
            InternetHeader h2 = this.headers.get(i2);
            if (name.equalsIgnoreCase(h2.getName())) {
                if (addReverse) {
                    pos = i2;
                } else {
                    this.headers.add(i2 + 1, new InternetHeader(name, value));
                    return;
                }
            }
            if (addReverse || !h2.getName().equals(":")) continue;
            pos = i2;
        }
        this.headers.add(pos, new InternetHeader(name, value));
    }

    public void removeHeader(String name) {
        for (int i2 = 0; i2 < this.headers.size(); ++i2) {
            InternetHeader h2 = this.headers.get(i2);
            if (!name.equalsIgnoreCase(h2.getName())) continue;
            h2.line = null;
        }
    }

    public Enumeration<Header> getAllHeaders() {
        return new MatchHeaderEnum(this.headers, null, false);
    }

    public Enumeration<Header> getMatchingHeaders(String[] names) {
        return new MatchHeaderEnum(this.headers, names, true);
    }

    public Enumeration<Header> getNonMatchingHeaders(String[] names) {
        return new MatchHeaderEnum(this.headers, names, false);
    }

    public void addHeaderLine(String line) {
        try {
            char c2 = line.charAt(0);
            if (c2 == ' ' || c2 == '\t') {
                InternetHeader h2 = this.headers.get(this.headers.size() - 1);
                h2.line = h2.line + "\r\n" + line;
            } else {
                this.headers.add(new InternetHeader(line));
            }
        }
        catch (StringIndexOutOfBoundsException e2) {
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Enumeration<String> getAllHeaderLines() {
        return this.getNonMatchingHeaderLines(null);
    }

    public Enumeration<String> getMatchingHeaderLines(String[] names) {
        return new MatchStringEnum(this.headers, names, true);
    }

    public Enumeration<String> getNonMatchingHeaderLines(String[] names) {
        return new MatchStringEnum(this.headers, names, false);
    }

    static class MatchHeaderEnum
    extends MatchEnum
    implements Enumeration<Header> {
        MatchHeaderEnum(List<InternetHeader> v2, String[] n2, boolean m3) {
            super(v2, n2, m3, false);
        }

        @Override
        public Header nextElement() {
            return (Header)super.nextElement();
        }
    }

    static class MatchStringEnum
    extends MatchEnum
    implements Enumeration<String> {
        MatchStringEnum(List<InternetHeader> v2, String[] n2, boolean m3) {
            super(v2, n2, m3, true);
        }

        @Override
        public String nextElement() {
            return (String)super.nextElement();
        }
    }

    static class MatchEnum {
        private Iterator<InternetHeader> e;
        private String[] names;
        private boolean match;
        private boolean want_line;
        private InternetHeader next_header;

        MatchEnum(List<InternetHeader> v2, String[] n2, boolean m3, boolean l2) {
            this.e = v2.iterator();
            this.names = n2;
            this.match = m3;
            this.want_line = l2;
            this.next_header = null;
        }

        public boolean hasMoreElements() {
            if (this.next_header == null) {
                this.next_header = this.nextMatch();
            }
            return this.next_header != null;
        }

        public Object nextElement() {
            if (this.next_header == null) {
                this.next_header = this.nextMatch();
            }
            if (this.next_header == null) {
                throw new NoSuchElementException("No more headers");
            }
            InternetHeader h2 = this.next_header;
            this.next_header = null;
            if (this.want_line) {
                return h2.line;
            }
            return new Header(h2.getName(), h2.getValue());
        }

        private InternetHeader nextMatch() {
            block0: while (this.e.hasNext()) {
                InternetHeader h2 = this.e.next();
                if (h2.line == null) continue;
                if (this.names == null) {
                    return this.match ? null : h2;
                }
                for (int i2 = 0; i2 < this.names.length; ++i2) {
                    if (!this.names[i2].equalsIgnoreCase(h2.getName())) continue;
                    if (!this.match) continue block0;
                    return h2;
                }
                if (this.match) continue;
                return h2;
            }
            return null;
        }
    }

    protected static final class InternetHeader
    extends Header {
        String line;

        public InternetHeader(String l2) {
            super("", "");
            int i2 = l2.indexOf(58);
            this.name = i2 < 0 ? l2.trim() : l2.substring(0, i2).trim();
            this.line = l2;
        }

        public InternetHeader(String n2, String v2) {
            super(n2, "");
            this.line = v2 != null ? n2 + ": " + v2 : null;
        }

        @Override
        public String getValue() {
            char c2;
            int j2;
            int i2 = this.line.indexOf(58);
            if (i2 < 0) {
                return this.line;
            }
            for (j2 = i2 + 1; j2 < this.line.length() && ((c2 = this.line.charAt(j2)) == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n'); ++j2) {
            }
            return this.line.substring(j2);
        }
    }
}

