/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ELManager;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

public class ELProcessor {
    private ELManager elManager = new ELManager();
    private ExpressionFactory factory;

    public ELProcessor() {
        ELProcessor eLProcessor = this;
        this.factory = eLProcessor.elManager.getExpressionFactory();
    }

    public ELManager getELManager() {
        return this.elManager;
    }

    public Object eval(String expression) {
        return this.getValue(expression, Object.class);
    }

    public Object getValue(String expression, Class<?> expectedType) {
        ValueExpression exp = this.factory.createValueExpression(this.elManager.getELContext(), this.bracket(expression), expectedType);
        return exp.getValue(this.elManager.getELContext());
    }

    public void setValue(String expression, Object value) {
        ValueExpression exp = this.factory.createValueExpression(this.elManager.getELContext(), this.bracket(expression), Object.class);
        exp.setValue(this.elManager.getELContext(), value);
    }

    public void setVariable(String var, String expression) {
        ValueExpression exp = this.factory.createValueExpression(this.elManager.getELContext(), this.bracket(expression), Object.class);
        this.elManager.setVariable(var, exp);
    }

    public void defineFunction(String prefix, String function, String className, String method) throws ClassNotFoundException, NoSuchMethodException {
        if (prefix == null || function == null || className == null || method == null) {
            throw new NullPointerException("Null argument for defineFunction");
        }
        Method meth = null;
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> klass = Class.forName(className, false, loader);
        int j2 = method.indexOf(40);
        if (j2 < 0) {
            for (Method m3 : klass.getDeclaredMethods()) {
                if (!m3.getName().equals(method)) continue;
                meth = m3;
            }
            if (meth == null) {
                throw new NoSuchMethodException();
            }
        } else {
            int p2 = method.indexOf(32);
            if (p2 < 0) {
                throw new NoSuchMethodException("Bad method singnature: " + method);
            }
            String methodName = method.substring(p2 + 1, j2).trim();
            p2 = method.indexOf(41, j2 + 1);
            if (p2 < 0) {
                throw new NoSuchMethodException("Bad method singnature: " + method);
            }
            String[] params = method.substring(j2 + 1, p2).split(",");
            Class[] paramTypes = new Class[params.length];
            for (int i2 = 0; i2 < params.length; ++i2) {
                paramTypes[i2] = ELProcessor.toClass(params[i2], loader);
            }
            meth = klass.getDeclaredMethod(methodName, paramTypes);
        }
        if (!Modifier.isStatic(meth.getModifiers())) {
            throw new NoSuchMethodException("The method specified in defineFunction must be static: " + meth);
        }
        if (function.equals("")) {
            function = method;
        }
        this.elManager.mapFunction(prefix, function, meth);
    }

    public void defineFunction(String prefix, String function, Method method) throws NoSuchMethodException {
        if (prefix == null || function == null || method == null) {
            throw new NullPointerException("Null argument for defineFunction");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("The method specified in defineFunction must be static: " + method);
        }
        if (function.equals("")) {
            function = method.getName();
        }
        this.elManager.mapFunction(prefix, function, method);
    }

    public void defineBean(String name, Object bean) {
        this.elManager.defineBean(name, bean);
    }

    private static Class<?> toClass(String type, ClassLoader loader) throws ClassNotFoundException {
        Class<Serializable> c2 = null;
        int i0 = type.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i2 = 0; i2 < type.length(); ++i2) {
                if (type.charAt(i2) != '[') continue;
                ++dims;
            }
            type = type.substring(0, i0);
        }
        c2 = "boolean".equals(type) ? Boolean.TYPE : ("char".equals(type) ? Character.TYPE : ("byte".equals(type) ? Byte.TYPE : ("short".equals(type) ? Short.TYPE : ("int".equals(type) ? Integer.TYPE : ("long".equals(type) ? Long.TYPE : ("float".equals(type) ? Float.TYPE : ("double".equals(type) ? Double.TYPE : loader.loadClass(type))))))));
        if (dims == 0) {
            return c2;
        }
        if (dims == 1) {
            return Array.newInstance(c2, 1).getClass();
        }
        return Array.newInstance(c2, new int[dims]).getClass();
    }

    private String bracket(String expression) {
        return "${" + expression + '}';
    }
}

