/*
 * Decompiled with CFR 0.152.
 */
package javassist.convert;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;
import javassist.convert.Transformer;

public final class TransformNew
extends Transformer {
    private int nested;
    private String classname;
    private String trapClass;
    private String trapMethod;

    public TransformNew(Transformer next, String classname, String trapClass, String trapMethod) {
        super(next);
        this.classname = classname;
        this.trapClass = trapClass;
        this.trapMethod = trapMethod;
    }

    @Override
    public void initialize(ConstPool cp2, CodeAttribute attr) {
        this.nested = 0;
    }

    @Override
    public int transform(CtClass clazz, int pos, CodeIterator iterator2, ConstPool cp2) throws CannotCompileException {
        int index;
        int typedesc;
        int c2 = iterator2.byteAt(pos);
        if (c2 == 187) {
            int index2 = iterator2.u16bitAt(pos + 1);
            if (cp2.getClassInfo(index2).equals(this.classname)) {
                StackMap sm;
                if (iterator2.byteAt(pos + 3) != 89) {
                    throw new CannotCompileException("NEW followed by no DUP was found");
                }
                iterator2.writeByte(0, pos);
                iterator2.writeByte(0, pos + 1);
                iterator2.writeByte(0, pos + 2);
                iterator2.writeByte(0, pos + 3);
                ++this.nested;
                StackMapTable smt = (StackMapTable)iterator2.get().getAttribute("StackMapTable");
                if (smt != null) {
                    smt.removeNew(pos);
                }
                if ((sm = (StackMap)iterator2.get().getAttribute("StackMap")) != null) {
                    sm.removeNew(pos);
                }
            }
        } else if (c2 == 183 && (typedesc = cp2.isConstructor(this.classname, index = iterator2.u16bitAt(pos + 1))) != 0 && this.nested > 0) {
            int methodref = this.computeMethodref(typedesc, cp2);
            iterator2.writeByte(184, pos);
            iterator2.write16bit(methodref, pos + 1);
            --this.nested;
        }
        return pos;
    }

    private int computeMethodref(int typedesc, ConstPool cp2) {
        int classIndex = cp2.addClassInfo(this.trapClass);
        int mnameIndex = cp2.addUtf8Info(this.trapMethod);
        typedesc = cp2.addUtf8Info(Descriptor.changeReturnType(this.classname, cp2.getUtf8Info(typedesc)));
        return cp2.addMethodrefInfo(classIndex, cp2.addNameAndTypeInfo(mnameIndex, typedesc));
    }
}

