/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.util;

import com.google.common.base.CharMatcher;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import org.simplejavamail.api.email.Recipient;

public class Tools {
    private static final CharMatcher SAFE_PARAMETER = CharMatcher.javaLetterOrDigit().or(CharMatcher.whitespace()).or(CharMatcher.anyOf("_.-/:")).precomputed();
    private static final Pattern SAFE_ID = Pattern.compile("^[a-zA-Z0-9-_]+$");
    private static final Pattern EMAIL_RECIPIENT_PATTERN = Pattern.compile("^(.+)<(.+)>$");

    public static boolean isValidUTF8(byte[] input) {
        CharsetDecoder cs2 = Charset.forName("UTF-8").newDecoder();
        try {
            cs2.decode(ByteBuffer.wrap(input));
            return true;
        }
        catch (CharacterCodingException e2) {
            return false;
        }
    }

    public static boolean isHumanlyReadable(String string) {
        int length = string.length();
        int controlChars = 0;
        int whitespaces = 0;
        for (char c2 : string.toCharArray()) {
            if (Character.isISOControl(c2)) {
                ++controlChars;
            }
            if (!Character.isISOControl(c2)) continue;
            ++whitespaces;
        }
        return length != controlChars && length != whitespaces;
    }

    public static int calculateSignalQuality(int antennaSignal) {
        if (antennaSignal >= -50) {
            return 100;
        }
        if (antennaSignal <= -100) {
            return 0;
        }
        return 2 * (antennaSignal + 100);
    }

    public static boolean isSafeParameter(String x2) {
        if (x2 == null) {
            return true;
        }
        return SAFE_PARAMETER.matchesAllOf(x2);
    }

    public static boolean isSafeID(String x2) {
        return SAFE_ID.matcher(x2).matches();
    }

    public static String byteArrayToHexPrettyPrint(byte[] a2) {
        StringBuilder sb = new StringBuilder(a2.length * 2);
        for (byte b2 : a2) {
            sb.append(String.format("%02x", b2)).append(" ");
        }
        return sb.toString();
    }

    public static String safeAlphanumericString(String x2) {
        return x2.replaceAll("[^A-Za-z0-9]", "");
    }

    public static Integer getInteger(Object value) {
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new RuntimeException("Cannot cast object of type [" + value.getClass().getCanonicalName() + "] to Integer.");
    }

    public static Recipient parseEmailAddress(String s2) throws InvalidConfigurationException {
        try {
            Matcher matcher = EMAIL_RECIPIENT_PATTERN.matcher(s2);
            if (!matcher.find()) {
                throw new InvalidConfigurationException("Invalid email address: (no match) [" + s2 + "] (correct format: \"Some Body <somebody@example.org>\"");
            }
            return new Recipient(matcher.group(1).trim(), matcher.group(2).trim(), Message.RecipientType.TO);
        }
        catch (Exception e2) {
            throw new InvalidConfigurationException("Invalid email address: [" + s2 + "] (correct format: \"Some Body <somebody@example.org>\"", e2);
        }
    }
}

