/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.systemstatus;

import com.google.common.collect.Sets;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemStatus {
    private static final Logger LOG = LogManager.getLogger(SystemStatus.class);
    private Set<TYPE> currentStatus = Sets.newHashSet();

    public HEALTH decideHealth(NzymeLeader nzyme) {
        for (Dot11Probe probe : nzyme.getProbes()) {
            if (probe.isInLoop() && probe.isActive()) continue;
            return HEALTH.RED;
        }
        return HEALTH.GREEN;
    }

    public boolean isInStatus(TYPE status) {
        return this.currentStatus.contains((Object)status);
    }

    public void setStatus(TYPE status) {
        if (!this.currentStatus.contains((Object)status)) {
            this.currentStatus.add(status);
            LOG.info("Set system status [{}].", (Object)status);
        } else {
            LOG.warn("Tried to set status [{}] but it was already set.", (Object)status);
        }
    }

    public void unsetStatus(TYPE status) {
        if (this.currentStatus.contains((Object)status)) {
            this.currentStatus.remove((Object)status);
            LOG.info("Unset system status [{}].", (Object)status);
        } else {
            LOG.warn("Tried to unset status [{}] but it was not set.", (Object)status);
        }
    }

    public static enum HEALTH {
        GREEN,
        RED;

    }

    public static enum TYPE {
        RUNNING,
        SHUTTING_DOWN,
        TRAINING;

    }
}

