/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.tls;

import horse.wtf.nzyme.rest.tls.PemReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class PemKeyStore {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] password, byte[] key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (password == null || password.length == 0) {
            return new PKCS8EncodedKeySpec(key);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKey pbeKey = keyFactory.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)pbeKey, encryptedPrivateKeyInfo.getAlgParameters());
        return encryptedPrivateKeyInfo.getKeySpec(cipher);
    }

    public static KeyStore buildKeyStore(Path certChainFile, Path keyFile, char[] keyPasswordChars) throws KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, CertificateException, KeyException, IOException {
        PrivateKey key;
        char[] password = keyPasswordChars == null ? EMPTY_CHAR_ARRAY : keyPasswordChars;
        byte[] encodedKey = PemReader.readPrivateKey(keyFile);
        PKCS8EncodedKeySpec encodedKeySpec = PemKeyStore.generateKeySpec(keyPasswordChars, encodedKey);
        try {
            key = KeyFactory.getInstance("RSA").generatePrivate(encodedKeySpec);
        }
        catch (InvalidKeySpecException ignore) {
            try {
                key = KeyFactory.getInstance("DSA").generatePrivate(encodedKeySpec);
            }
            catch (InvalidKeySpecException ignore2) {
                try {
                    key = KeyFactory.getInstance("EC").generatePrivate(encodedKeySpec);
                }
                catch (InvalidKeySpecException e2) {
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", e2);
                }
            }
        }
        CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
        List<byte[]> certs = PemReader.readCertificates(certChainFile);
        ArrayList<Certificate> certChain = new ArrayList<Certificate>(certs.size());
        for (byte[] buf : certs) {
            certChain.add(cf2.generateCertificate(new ByteArrayInputStream(buf)));
        }
        KeyStore ks2 = KeyStore.getInstance(KeyStore.getDefaultType());
        ks2.load(null, password);
        ks2.setKeyEntry("key", key, password, certChain.toArray(new Certificate[certChain.size()]));
        return ks2;
    }
}

