/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.responses.alerts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.rest.responses.alerts.AutoValue_AlertDetailsResponse;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@AutoValue
public abstract class AlertDetailsResponse {
    @JsonProperty(value="subsystem")
    public abstract Subsystem subsystem();

    @JsonProperty(value="type")
    public abstract Alert.TYPE type();

    @JsonProperty(value="id")
    public abstract UUID id();

    @JsonProperty(value="is_active")
    public abstract boolean isActive();

    @JsonProperty(value="message")
    public abstract String message();

    @JsonProperty(value="fields")
    public abstract Map<String, Object> fields();

    @JsonProperty(value="first_seen")
    public abstract DateTime firstSeen();

    @JsonProperty(value="last_seen")
    public abstract DateTime lastSeen();

    @JsonProperty(value="frame_count")
    @Nullable
    public abstract Long frameCount();

    @JsonProperty(value="description")
    public abstract String description();

    @JsonProperty(value="documentation_link")
    public abstract String documentationLink();

    @JsonProperty(value="false_positives")
    public abstract List<String> falsePositives();

    public static AlertDetailsResponse fromAlert(Alert alert) {
        return AlertDetailsResponse.builder().subsystem(alert.getSubsystem()).type(alert.getType()).id(alert.getUUID()).isActive(alert.getLastSeen().isAfter(DateTime.now().minusMinutes(10))).message(alert.getMessage()).fields(alert.getFields()).firstSeen(alert.getFirstSeen()).lastSeen(alert.getLastSeen()).description(alert.getDescription()).documentationLink(alert.getDocumentationLink()).falsePositives(alert.getFalsePositives()).frameCount(alert.getFrameCount()).build();
    }

    public static Builder builder() {
        return new AutoValue_AlertDetailsResponse.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder subsystem(Subsystem var1);

        public abstract Builder type(Alert.TYPE var1);

        public abstract Builder id(UUID var1);

        public abstract Builder isActive(boolean var1);

        public abstract Builder message(String var1);

        public abstract Builder fields(Map<String, Object> var1);

        public abstract Builder firstSeen(DateTime var1);

        public abstract Builder lastSeen(DateTime var1);

        public abstract Builder frameCount(Long var1);

        public abstract Builder description(String var1);

        public abstract Builder documentationLink(String var1);

        public abstract Builder falsePositives(List<String> var1);

        public abstract AlertDetailsResponse build();
    }
}

