/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources.system;

import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.dot11.probes.Dot11SenderProbe;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.system.ProbeResponse;
import horse.wtf.nzyme.rest.responses.system.ProbesListResponse;
import horse.wtf.nzyme.rest.responses.system.TrapResponse;
import horse.wtf.nzyme.rest.responses.system.TrapsListResponse;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/api/system/probes")
@Secured
@Produces(value={"application/json"})
public class ProbesResource {
    @Inject
    private NzymeLeader nzyme;

    @GET
    @Secured
    public Response all() {
        ArrayList<ProbeResponse> response = Lists.newArrayList();
        for (Dot11Probe probe : this.nzyme.getProbes()) {
            response.add(ProbeResponse.create(probe.getName(), probe.getClass().getSimpleName(), probe.getConfiguration().networkInterfaceName(), probe.isInLoop(), probe.isActive(), probe.getConfiguration().channels(), probe.getCurrentChannel(), probe.getTotalFrames()));
        }
        return Response.ok(ProbesListResponse.create(response.size(), response)).build();
    }

    @GET
    @Path(value="/traps")
    public Response traps() {
        ArrayList<TrapResponse> traps = Lists.newArrayList();
        for (Dot11Probe probe : this.nzyme.getProbes()) {
            if (!(probe instanceof Dot11SenderProbe)) continue;
            Dot11SenderProbe sender = (Dot11SenderProbe)probe;
            traps.add(TrapResponse.create(ProbeResponse.create(probe.getName(), probe.getClass().getSimpleName(), probe.getConfiguration().networkInterfaceName(), probe.isInLoop(), probe.isActive(), probe.getConfiguration().channels(), probe.getCurrentChannel(), probe.getTotalFrames()), sender.getTrap().getType().toString(), sender.getTrap().getDescription()));
        }
        return Response.ok(TrapsListResponse.create(traps)).build();
    }
}

