/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources.system;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.metrics.CounterResponse;
import horse.wtf.nzyme.rest.responses.metrics.GaugeResponse;
import horse.wtf.nzyme.rest.responses.metrics.MeterResponse;
import horse.wtf.nzyme.rest.responses.metrics.MetricsListResponse;
import horse.wtf.nzyme.rest.responses.metrics.TimerResponse;
import horse.wtf.nzyme.util.MetricNames;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/api/system/metrics")
@Secured
@Produces(value={"application/json"})
public class MetricsResource {
    @Inject
    private NzymeLeader nzyme;

    @GET
    public Response all() {
        HashMap<String, Object> metrics = Maps.newHashMap();
        metrics.put("total_frames", MeterResponse.fromMeter(this.getMeter(MetricNames.FRAME_COUNT)));
        metrics.put("frame_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.FRAME_TIMER)));
        metrics.put("oui_lookup_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.OUI_LOOKUP_TIMING)));
        metrics.put("tagged_params_parse_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.TAGGED_PARAMS_PARSE_TIMING)));
        metrics.put("tagged_params_fingerprint_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.TAGGED_PARAMS_FINGERPRINT_TIMING)));
        metrics.put("mem_heap_init", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.heap.init")));
        metrics.put("mem_heap_max", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.heap.max")));
        metrics.put("mem_heap_used", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.heap.used")));
        metrics.put("mem_heap_usage_percent", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.heap.usage")));
        metrics.put("mem_nonheap_init", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.non-heap.init")));
        metrics.put("mem_nonheap_max", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.non-heap.max")));
        metrics.put("mem_nonheap_used", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.non-heap.used")));
        metrics.put("mem_nonheap_usage_percent", GaugeResponse.fromGauge((Gauge)this.nzyme.getMetrics().getGauges().get("mem.non-heap.usage")));
        metrics.put("beaconrate_monitor_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.BEACON_RATE_MONITOR_TIMING)));
        metrics.put("signaltables_mutex_wait", TimerResponse.fromTimer(this.getTimer(MetricNames.SIGNAL_TABLES_MUTEX_WAIT)));
        metrics.put("signaltrack_monitor_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.SIGNAL_TRACK_MONITOR_TIMING)));
        metrics.put("contact_identifier_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.CONTACT_IDENTIFIER_TIMING)));
        metrics.put("groundstation_rx", CounterResponse.fromCounter(this.getCounter(MetricNames.GROUNDSTATION_RX)));
        metrics.put("groundstation_tx", CounterResponse.fromCounter(this.getCounter(MetricNames.GROUNDSTATION_TX)));
        metrics.put("groundstation_encryption_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.GROUNDSTATION_ENCRYPTION_TIMING)));
        metrics.put("groundstation_queue_size", GaugeResponse.fromGauge(this.getGauge(MetricNames.GROUNDSTATION_QUEUE_SIZE)));
        metrics.put("remote_frames_received", CounterResponse.fromCounter(this.getCounter(MetricNames.REMOTE_FRAMES_RECEIVED)));
        metrics.put("remote_frames_timing", TimerResponse.fromTimer(this.getTimer(MetricNames.REMOTE_FRAMES_TIMING)));
        metrics.put("database_size", GaugeResponse.fromGauge(this.getGauge(MetricNames.DATABASE_SIZE)));
        return Response.ok(MetricsListResponse.create(metrics.size(), metrics)).build();
    }

    private Meter getMeter(String name) {
        Meter meter = (Meter)this.nzyme.getMetrics().getMeters().get(name);
        return meter == null ? new Meter() : meter;
    }

    private Timer getTimer(String name) {
        Timer timer = (Timer)this.nzyme.getMetrics().getTimers().get(name);
        return timer == null ? new Timer() : timer;
    }

    private Counter getCounter(String name) {
        Counter counter = (Counter)this.nzyme.getMetrics().getCounters().get(name);
        return counter == null ? new Counter() : counter;
    }

    private Gauge getGauge(String name) {
        Gauge gauge = (Gauge)this.nzyme.getMetrics().getGauges().get(name);
        return gauge == null ? () -> "" : gauge;
    }
}

