/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources.authentication;

import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.requests.CreateSessionRequest;
import horse.wtf.nzyme.rest.responses.authentication.SessionInformationResponse;
import horse.wtf.nzyme.rest.responses.authentication.SessionTokenResponse;
import horse.wtf.nzyme.security.sessions.Session;
import horse.wtf.nzyme.security.sessions.StaticHashAuthenticator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Seconds;

@Path(value="/api/authentication")
@Produces(value={"application/json"})
public class AuthenticationResource {
    private static final Logger LOG = LogManager.getLogger(AuthenticationResource.class);
    @Inject
    private NzymeLeader nzyme;
    @Context
    SecurityContext securityContext;

    @POST
    @Path(value="/session")
    @Consumes(value={"application/json"})
    public Response createSession(@NotNull CreateSessionRequest request) {
        String password;
        String username;
        StaticHashAuthenticator authenticator = new StaticHashAuthenticator(this.nzyme.getConfiguration());
        if (authenticator.authenticate(username = request.username(), password = request.password())) {
            String token = Session.createToken(username, this.nzyme.getSigningKey());
            LOG.info("Creating session for user [{}]", (Object)username);
            return Response.status(Response.Status.CREATED).entity(SessionTokenResponse.create(token)).build();
        }
        LOG.warn("Failed login attempt for user [{}].", (Object)username);
        return Response.status(Response.Status.FORBIDDEN).build();
    }

    @Path(value="/session/information")
    @Secured
    @GET
    public Response information() {
        try {
            Jws<Claims> claims = Jwts.parser().setSigningKey(this.nzyme.getSigningKey()).parseClaimsJws(this.securityContext.getUserPrincipal().getName());
            DateTime expiresAt = new DateTime(((Claims)claims.getBody()).getExpiration());
            return Response.ok(SessionInformationResponse.create(SessionInformationResponse.STATUS.VALID, Seconds.secondsBetween(DateTime.now(), expiresAt).getSeconds())).build();
        }
        catch (Exception e2) {
            return Response.ok(SessionInformationResponse.create(SessionInformationResponse.STATUS.INVALID, 0)).build();
        }
    }
}

