/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.authentication;

import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.rest.authentication.Secured;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SignatureException;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Secured
@Provider
@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LogManager.getLogger(AuthenticationFilter.class);
    private final NzymeLeader nzyme;
    private static final String AUTHENTICATION_SCHEME = "Bearer";

    public AuthenticationFilter(NzymeLeader nzyme) {
        this.nzyme = nzyme;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (!this.isTokenBasedAuthentication(authorizationHeader)) {
            this.abortWithUnauthorized(requestContext);
            return;
        }
        final String token = authorizationHeader.substring(AUTHENTICATION_SCHEME.length()).trim();
        try {
            this.validateToken(token);
            final SecurityContext currentSecurityContext = requestContext.getSecurityContext();
            requestContext.setSecurityContext(new SecurityContext(){

                @Override
                public Principal getUserPrincipal() {
                    return () -> token;
                }

                @Override
                public boolean isUserInRole(String role) {
                    return true;
                }

                @Override
                public boolean isSecure() {
                    return currentSecurityContext.isSecure();
                }

                @Override
                public String getAuthenticationScheme() {
                    return AuthenticationFilter.AUTHENTICATION_SCHEME;
                }
            });
        }
        catch (SignatureException e2) {
            LOG.debug("Invalid signature of JWT token. This could be an old session running in a browser somewhere. Token was: [{}]", (Object)token, (Object)e2);
            this.abortWithUnauthorized(requestContext);
        }
        catch (ExpiredJwtException e3) {
            LOG.info("Token is expired. Please create a new session by logging in.  Token was: [{}]", (Object)token, (Object)e3);
            this.abortWithUnauthorized(requestContext);
        }
        catch (Exception e4) {
            LOG.info("Token parsing failed.  Token was: [{}]", (Object)token, (Object)e4);
            this.abortWithUnauthorized(requestContext);
        }
    }

    private boolean isTokenBasedAuthentication(String authorizationHeader) {
        return authorizationHeader != null && authorizationHeader.toLowerCase().startsWith(AUTHENTICATION_SCHEME.toLowerCase() + " ");
    }

    private void abortWithUnauthorized(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).build());
    }

    private void validateToken(String token) throws SignatureException, ExpiredJwtException {
        Jwts.parser().setSigningKey(this.nzyme.getSigningKey()).parseClaimsJws(token);
    }
}

