/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.MultivaluedMap;

public class RestTools {
    public static final String OVERRIDE_HEADER = "X-Nzyme-URL";

    public static URI buildExternalUri(@NotNull MultivaluedMap<String, String> httpHeaders, @NotNull URI defaultUri) {
        URI uri;
        Optional<URI> externalUri = Optional.empty();
        List headers = (List)httpHeaders.get(OVERRIDE_HEADER);
        if (headers != null && !headers.isEmpty()) {
            externalUri = headers.stream().filter(s2 -> {
                try {
                    if (Strings.isNullOrEmpty(s2)) {
                        return false;
                    }
                    URI uri = new URI((String)s2);
                    if (!uri.isAbsolute()) {
                        return true;
                    }
                    switch (uri.getScheme()) {
                        case "http": 
                        case "https": {
                            return true;
                        }
                    }
                    return false;
                }
                catch (URISyntaxException e2) {
                    return false;
                }
            }).map(URI::create).findFirst();
        }
        if (!(uri = externalUri.orElse(defaultUri)).toString().endsWith("/")) {
            return URI.create(uri.toString() + "/");
        }
        return uri;
    }
}

