/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals.measurements;

import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.measurements.MeasurementType;
import horse.wtf.nzyme.periodicals.Periodical;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeasurementsWriter
extends Periodical {
    private static final Logger LOG = LogManager.getLogger(MeasurementsWriter.class);
    private final NzymeLeader nzyme;

    public MeasurementsWriter(NzymeLeader nzyme) {
        this.nzyme = nzyme;
    }

    @Override
    protected void execute() {
        LOG.debug("Updating measurements.");
        this.nzyme.getDatabase().useHandle(handle -> {
            handle.execute("INSERT INTO measurements(measurement_type, measurement_value, created_at) VALUES(?, ?, current_timestamp at time zone 'UTC')", new Object[]{MeasurementType.DOT11_ACCESS_POINT_COUNT, this.nzyme.getNetworks().getBSSIDs().keySet().size()});
            handle.execute("INSERT INTO measurements(measurement_type, measurement_value, created_at) VALUES(?, ?, current_timestamp at time zone 'UTC')", new Object[]{MeasurementType.DOT11_CLIENT_COUNT, this.nzyme.getClients().getClients().size()});
            handle.execute("INSERT INTO measurements(measurement_type, measurement_value, created_at) VALUES(?, ?, current_timestamp at time zone 'UTC')", new Object[]{MeasurementType.DOT11_FRAME_COUNT, this.nzyme.getFrameProcessor().getRecentFrameCount()});
        });
    }

    @Override
    public String getName() {
        return "MeasurementsWriter";
    }
}

