/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Periodical
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(Periodical.class);

    protected abstract void execute();

    public abstract String getName();

    @Override
    public void run() {
        LOG.debug("Running periodical [{}].", (Object)this.getName());
        Stopwatch timer = Stopwatch.createStarted();
        try {
            this.execute();
        }
        catch (Exception e2) {
            LOG.error("Error during execution of periodical [{}].", (Object)this.getName(), (Object)e2);
        }
        LOG.debug("Periodical [{}] finished in <{} ms>.", (Object)this.getName(), (Object)timer.elapsed(TimeUnit.MILLISECONDS));
    }
}

