/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.notifications.uplinks;

import com.typesafe.config.Config;
import horse.wtf.nzyme.configuration.UplinkDefinition;
import horse.wtf.nzyme.notifications.Uplink;
import horse.wtf.nzyme.notifications.uplinks.graylog.GraylogUplink;
import horse.wtf.nzyme.notifications.uplinks.syslog.SyslogUDPRFC3164UDPUplink;
import horse.wtf.nzyme.notifications.uplinks.syslog.SyslogUDPRFC5424UDPUplink;
import java.net.InetSocketAddress;

public class UplinkFactory {
    private final String nzymeId;

    public UplinkFactory(String nzymeId) {
        this.nzymeId = nzymeId;
    }

    public Uplink fromConfigurationDefinition(UplinkDefinition definition) {
        String def;
        switch (def = definition.type().toLowerCase()) {
            case "graylog": {
                return new GraylogUplink(this.parseInetSocketAddress(definition.configuration()), this.nzymeId);
            }
            case "syslog_udp_rfc5424": {
                return new SyslogUDPRFC5424UDPUplink(this.parseInetSocketAddress(definition.configuration()), this.nzymeId);
            }
            case "syslog_udp_rfc3164": {
                return new SyslogUDPRFC3164UDPUplink(this.parseInetSocketAddress(definition.configuration()), this.nzymeId);
            }
        }
        throw new RuntimeException("Unknown uplink type [" + def + "].");
    }

    private InetSocketAddress parseInetSocketAddress(Config config) {
        if (config.hasPath("host") && config.hasPath("port")) {
            return new InetSocketAddress(config.getString("host"), config.getInt("port"));
        }
        throw new RuntimeException("Invalid configuration. Expecting \"host\" and \"port\" set in uplink configuration. Please consult the uplink documentation.");
    }
}

