/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.probes;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import horse.wtf.nzyme.RemoteConnector;
import horse.wtf.nzyme.bandits.trackers.trackerlogic.ChannelDesignator;
import horse.wtf.nzyme.channels.ChannelHopper;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11FrameFactory;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeConfiguration;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeInitializationException;
import horse.wtf.nzyme.notifications.Notification;
import horse.wtf.nzyme.processing.FrameProcessor;
import horse.wtf.nzyme.util.MetricNames;
import java.io.EOFException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.namednumber.Dot11FrameType;

public class Dot11MonitorProbe
extends Dot11Probe {
    private static final Logger LOG = LogManager.getLogger(Dot11MonitorProbe.class);
    private final Dot11ProbeConfiguration configuration;
    private PcapHandle pcap;
    private final ChannelHopper channelHopper;
    private final ChannelDesignator channelDesignator;
    private final RemoteConnector remote;
    private final Dot11FrameFactory frameFactory;
    private final FrameProcessor frameProcessor;
    private final Meter globalFrameMeter;
    private final Timer globalFrameTimer;
    private final Meter localFrameMeter;
    private final AtomicBoolean inLoop = new AtomicBoolean(false);
    private DateTime mostRecentFrameTimestamp;

    public Dot11MonitorProbe(Dot11ProbeConfiguration configuration, FrameProcessor frameProcessor, MetricRegistry metrics, Anonymizer anonymizer, RemoteConnector remote, boolean hasDesignator) {
        super(configuration, metrics);
        this.remote = remote;
        this.configuration = configuration;
        this.frameFactory = new Dot11FrameFactory(metrics, anonymizer);
        this.frameProcessor = frameProcessor;
        this.globalFrameMeter = metrics.meter(MetricNames.FRAME_COUNT);
        this.globalFrameTimer = metrics.timer(MetricNames.FRAME_TIMER);
        this.localFrameMeter = metrics.meter(MetricRegistry.name(this.getClass(), this.getName(), "frameCount"));
        this.channelHopper = new ChannelHopper(this, configuration);
        this.channelHopper.initialize();
        this.channelDesignator = hasDesignator ? new ChannelDesignator(this) : null;
    }

    @Override
    public void initialize() throws Dot11ProbeInitializationException {
        PcapNetworkInterface networkInterface;
        try {
            networkInterface = Pcaps.getDevByName(this.configuration.networkInterfaceName());
        }
        catch (PcapNativeException e2) {
            throw new Dot11ProbeInitializationException("Could not get network interface [" + this.configuration.networkInterfaceName() + "].", e2);
        }
        if (networkInterface == null) {
            throw new Dot11ProbeInitializationException("Could not get network interface [" + this.configuration.networkInterfaceName() + "]. Does it exist and could it be that you have to be root? Is it up?");
        }
        LOG.info("Building PCAP handle on interface [{}]", (Object)this.configuration.networkInterfaceName());
        PcapHandle.Builder phb = new PcapHandle.Builder(networkInterface.getName()).rfmon(!this.configuration.skipEnableMonitor()).snaplen(65536).promiscuousMode(PcapNetworkInterface.PromiscuousMode.PROMISCUOUS).timeoutMillis(100).bufferSize(0x500000).timestampPrecision(PcapHandle.TimestampPrecision.MICRO);
        try {
            this.pcap = phb.build();
            this.pcap.setFilter("type mgt and (subtype deauth or subtype probe-req or subtype probe-resp or subtype beacon or subtype assoc-req or subtype assoc-resp or subtype disassoc or subtype auth)", BpfProgram.BpfCompileMode.OPTIMIZE);
        }
        catch (Exception e3) {
            throw new Dot11ProbeInitializationException("Could not build PCAP handle.", e3);
        }
        LOG.info("PCAP handle for [{}] acquired. Cycling through channels <{}>.", (Object)this.configuration.probeName(), (Object)Joiner.on(",").join(this.configuration.channels()));
    }

    @Override
    public Runnable loop() {
        return () -> {
            LOG.info("Commencing 802.11 frame processing on [{}] ... (\u2310\u25a0_\u25a0)\u2013\ufe3b\u2566\u2564\u2500 \u2013 \u2013 pew pew", (Object)this.configuration.networkInterfaceName());
            while (true) {
                Packet packet;
                block13: {
                    try {
                        if (this.isInLoop()) break block13;
                        this.initialize();
                    }
                    catch (Dot11ProbeInitializationException e2) {
                        this.inLoop.set(false);
                        LOG.error("Could not initialize probe [{}]. Retrying soon.", (Object)this.getName(), (Object)e2);
                        try {
                            Thread.sleep(2500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                this.inLoop.set(true);
                try {
                    packet = this.pcap.getNextPacketEx();
                }
                catch (EOFException | NotOpenException | PcapNativeException e3) {
                    this.inLoop.set(false);
                    LOG.error(e3);
                    continue;
                }
                catch (TimeoutException e4) {
                    continue;
                }
                catch (IllegalArgumentException e5) {
                    LOG.trace(e5);
                    continue;
                }
                if (packet == null) continue;
                this.globalFrameMeter.mark();
                this.localFrameMeter.mark();
                try {
                    if (!(packet instanceof RadiotapPacket)) continue;
                    Timer.Context time = this.globalFrameTimer.time();
                    RadiotapPacket r2 = (RadiotapPacket)packet;
                    byte[] payload = r2.getPayload().getRawData();
                    Dot11MetaInformation meta = Dot11MetaInformation.parse(r2.getHeader().getDataFields());
                    if (meta.isMalformed()) {
                        LOG.trace("Bad checksum. Skipping malformed packet on probe [{}].", (Object)this.getName());
                        this.notifyOfMalformedFrame(meta);
                        continue;
                    }
                    Dot11FrameType type = Dot11FrameType.getInstance((byte)(payload[0] << 2 & 0x30 | payload[0] >> 4 & 0xF));
                    this.mostRecentFrameTimestamp = DateTime.now();
                    this.frameProcessor.processDot11Frame(this.frameFactory.build(type, payload, r2.getHeader().getRawData(), meta));
                    time.stop();
                    continue;
                }
                catch (MalformedFrameException | ArrayIndexOutOfBoundsException | IllegalArgumentException e6) {
                    LOG.debug("Illegal data received on probe [{}].", (Object)this.getName(), (Object)e6);
                    continue;
                }
                catch (Exception e7) {
                    LOG.error("Could not process packet on probe [{}].", (Object)this.getName(), (Object)e7);
                    continue;
                }
                break;
            }
        };
    }

    public ChannelDesignator getChannelDesignator() {
        return this.channelDesignator;
    }

    public ChannelHopper getChannelHopper() {
        return this.channelHopper;
    }

    @Override
    public boolean isInLoop() {
        return this.inLoop.get();
    }

    @Override
    public Integer getCurrentChannel() {
        return this.channelHopper.getCurrentChannel();
    }

    @Override
    public Long getTotalFrames() {
        if (this.localFrameMeter != null) {
            return this.localFrameMeter.getCount();
        }
        return -1L;
    }

    @Override
    @Nullable
    public DateTime getMostRecentFrameTimestamp() {
        return this.mostRecentFrameTimestamp;
    }

    public void onChannelSwitch(ChannelHopper.ChannelSwitchHandler handler) {
        this.channelHopper.onChannelSwitch(handler);
    }

    private void notifyOfMalformedFrame(Dot11MetaInformation meta) {
        int channel = 0;
        if (meta != null) {
            channel = meta.getChannel();
        }
        this.remote.notifyUplinks(new Notification("Malformed frame received.", channel).addField("subtype", "malformed"), meta);
    }
}

