/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeRequestFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import org.pcap4j.packet.Dot11ProbeRequestPacket;
import org.pcap4j.packet.IllegalRawDataException;

public class Dot11ProbeRequestFrameParser
extends Dot11FrameParser<Dot11ProbeRequestFrame> {
    private final Anonymizer anonymizer;

    public Dot11ProbeRequestFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11ProbeRequestFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        String ssid;
        Dot11ProbeRequestPacket probeRequest = Dot11ProbeRequestPacket.newPacket(payload, 0, payload.length);
        if (probeRequest.getHeader() == null) {
            throw new MalformedFrameException("Malformed header in probe request packet. Skipping.");
        }
        boolean broadcastProbe = false;
        if (probeRequest.getHeader().getSsid() != null) {
            ssid = probeRequest.getHeader().getSsid().getSsid();
            if (Strings.isNullOrEmpty(ssid)) {
                ssid = null;
                broadcastProbe = true;
            }
        } else {
            ssid = null;
            broadcastProbe = true;
        }
        if (probeRequest.getHeader().getAddress2() == null) {
            throw new MalformedFrameException("Missing requester address.");
        }
        String requester = probeRequest.getHeader().getAddress2().toString();
        if (this.anonymizer.isEnabled()) {
            ssid = this.anonymizer.anonymizeSSID(ssid);
            requester = this.anonymizer.anonymizeBSSID(requester);
        }
        return Dot11ProbeRequestFrame.create(requester, ssid, broadcastProbe, meta, payload, header);
    }
}

