/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11LeavingReason;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11DisassociationFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import org.pcap4j.packet.IllegalRawDataException;

public class Dot11DisassociationFrameParser
extends Dot11FrameParser<Dot11DisassociationFrame> {
    private final Anonymizer anonymizer;

    public Dot11DisassociationFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11DisassociationFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException {
        Dot11ManagementFrame disassociationRequest = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        String destination = "";
        if (disassociationRequest.getHeader().getAddress1() != null) {
            destination = disassociationRequest.getHeader().getAddress1().toString();
        }
        String transmitter = "";
        if (disassociationRequest.getHeader().getAddress2() != null) {
            transmitter = disassociationRequest.getHeader().getAddress2().toString();
        }
        short reasonCode = Dot11LeavingReason.extract(payload, header);
        String reasonString = Dot11LeavingReason.lookup(reasonCode);
        if (this.anonymizer.isEnabled()) {
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
            destination = this.anonymizer.anonymizeBSSID(destination);
        }
        return Dot11DisassociationFrame.create(destination, transmitter, reasonCode, reasonString, meta, payload, header);
    }
}

