/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.parsers;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11ManagementFrame;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.Dot11TaggedParameters;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11AssociationRequestFrame;
import horse.wtf.nzyme.dot11.parsers.Dot11FrameParser;
import org.pcap4j.packet.IllegalRawDataException;

public class Dot11AssociationRequestFrameParser
extends Dot11FrameParser<Dot11AssociationRequestFrame> {
    private final Anonymizer anonymizer;

    public Dot11AssociationRequestFrameParser(MetricRegistry metrics, Anonymizer anonymizer) {
        super(metrics);
        this.anonymizer = anonymizer;
    }

    @Override
    protected Dot11AssociationRequestFrame doParse(byte[] payload, byte[] header, Dot11MetaInformation meta) throws IllegalRawDataException, MalformedFrameException {
        String ssid;
        Dot11ManagementFrame associationRequest = Dot11ManagementFrame.newPacket(payload, 0, payload.length);
        Dot11TaggedParameters taggedParameters = new Dot11TaggedParameters(this.metrics, 28, payload);
        String destination = "";
        if (associationRequest.getHeader().getAddress1() != null) {
            destination = associationRequest.getHeader().getAddress1().toString();
        }
        String transmitter = "";
        if (associationRequest.getHeader().getAddress2() != null) {
            transmitter = associationRequest.getHeader().getAddress2().toString();
        }
        try {
            ssid = taggedParameters.getSSID();
        }
        catch (Dot11TaggedParameters.NoSuchTaggedElementException e2) {
            throw new IllegalRawDataException("No SSID in assoc-req frame. Not even empty SSID. This is a malformed frame.");
        }
        if (this.anonymizer.isEnabled()) {
            ssid = this.anonymizer.anonymizeSSID(ssid);
            transmitter = this.anonymizer.anonymizeBSSID(transmitter);
            destination = this.anonymizer.anonymizeBSSID(destination);
        }
        return Dot11AssociationRequestFrame.create(ssid, destination, transmitter, meta, payload, header);
    }
}

