/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks.signalstrength.tracks;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.AutoValue_TrackDetector_TrackDetectorConfig;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.PartialTrack;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.SignalWaterfallHistogram;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.Track;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class TrackDetector {
    private static final Logger LOG = LogManager.getLogger(TrackDetector.class);
    public static final TrackDetectorConfig DEFAULT_CONFIG = TrackDetectorConfig.create(20, 9, 8);
    private final SignalWaterfallHistogram histogram;

    public TrackDetector(SignalWaterfallHistogram histogram) throws IllegalArgumentException {
        this.histogram = histogram;
    }

    public List<Track> detect(TrackDetectorConfig config) {
        int yIdx = 0;
        HashMap partialTracks = Maps.newHashMap();
        for (List<Long> list : this.histogram.z()) {
            DateTime dateTime = this.histogram.y().get(yIdx);
            int x2 = -100;
            int trackLength = 0;
            int gapLength = 0;
            int trackStart = -1;
            for (Long z2 : list) {
                if (z2 > (long)config.frameThreshold() && x2 != -100) {
                    if (trackLength == 0) {
                        trackStart = x2;
                    }
                    ++trackLength;
                } else if (trackLength > 0 && (++gapLength >= config.gapThreshold() || x2 == 0)) {
                    PartialTrack partialTrack = PartialTrack.create(dateTime, trackStart, x2 - config.gapThreshold() + 2);
                    LOG.debug(partialTrack);
                    if (!partialTracks.containsKey(partialTrack.averageSignal())) {
                        partialTracks.put(partialTrack.averageSignal(), Lists.newArrayList());
                    }
                    ((List)partialTracks.get(partialTrack.averageSignal())).add(partialTrack);
                    trackLength = 0;
                    gapLength = 0;
                }
                ++x2;
            }
            ++yIdx;
        }
        HashMap<Integer, List> centerlineAveragedTracks = Maps.newHashMap();
        for (Map.Entry entry : partialTracks.entrySet()) {
            int partialCenterline = (Integer)entry.getKey();
            Optional<Object> matchingCenterline = Optional.empty();
            for (Integer existingCenterline : centerlineAveragedTracks.keySet()) {
                if (partialCenterline < existingCenterline - config.signalCenterlineJitter() || partialCenterline > existingCenterline + config.signalCenterlineJitter()) continue;
                matchingCenterline = Optional.of(existingCenterline);
            }
            if (matchingCenterline.isPresent()) {
                ((List)centerlineAveragedTracks.get(matchingCenterline.get())).addAll((Collection)entry.getValue());
                continue;
            }
            centerlineAveragedTracks.put(partialCenterline, (List)entry.getValue());
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Map.Entry aggregated : centerlineAveragedTracks.entrySet()) {
            PartialTrack first = (PartialTrack)((List)aggregated.getValue()).get(0);
            DateTime start = first.timestamp();
            DateTime end = first.timestamp();
            int minSignal = first.minSignal();
            int maxSignal = first.maxSignal();
            for (PartialTrack track : (List)aggregated.getValue()) {
                if (track.timestamp().isBefore(start)) {
                    start = track.timestamp();
                }
                if (track.timestamp().isAfter(end)) {
                    end = track.timestamp();
                }
                if (track.minSignal() < minSignal) {
                    minSignal = track.minSignal();
                }
                if (track.maxSignal() <= maxSignal) continue;
                maxSignal = track.maxSignal();
            }
            builder.add(Track.create(start, end, (Integer)aggregated.getKey(), minSignal, maxSignal));
        }
        return builder.build();
    }

    @AutoValue
    public static abstract class TrackDetectorConfig {
        public abstract int frameThreshold();

        public abstract int gapThreshold();

        public abstract int signalCenterlineJitter();

        public static TrackDetectorConfig create(int frameThreshold, int gapThreshold, int signalCenterlineJitter) {
            return TrackDetectorConfig.builder().frameThreshold(frameThreshold).gapThreshold(gapThreshold).signalCenterlineJitter(signalCenterlineJitter).build();
        }

        public static Builder builder() {
            return new AutoValue_TrackDetector_TrackDetectorConfig.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder frameThreshold(int var1);

            public abstract Builder gapThreshold(int var1);

            public abstract Builder signalCenterlineJitter(int var1);

            public abstract TrackDetectorConfig build();
        }
    }
}

