/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.UnknownSSIDAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import horse.wtf.nzyme.dot11.networks.sentry.Sentry;
import horse.wtf.nzyme.util.Tools;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class SentryInterceptorSet {
    private final Sentry sentry;
    private final AlertsService alerts;
    private final boolean unknownSSIDAlertEnabled;

    public SentryInterceptorSet(Sentry sentry, AlertsService alerts, boolean unknownSSIDAlertEnabled) {
        this.sentry = sentry;
        this.alerts = alerts;
        this.unknownSSIDAlertEnabled = unknownSSIDAlertEnabled;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11BeaconFrame>(){

            @Override
            public void intercept(Dot11BeaconFrame frame) {
                if (frame.ssid() == null || frame.ssid().trim().isEmpty() || !Tools.isHumanlyReadable(frame.ssid())) {
                    return;
                }
                if (SentryInterceptorSet.this.unknownSSIDAlertEnabled && !SentryInterceptorSet.this.sentry.knowsSSID(frame.ssid())) {
                    SentryInterceptorSet.this.alerts.handle(UnknownSSIDAlert.create(DateTime.now(), frame.ssid(), frame.transmitter(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal()));
                }
                SentryInterceptorSet.this.sentry.tickSSID(frame.ssid(), DateTime.now());
            }

            @Override
            public byte forSubtype() {
                return 8;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(UnknownSSIDAlert.class);
                    }
                };
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeResponseFrame>(){

            @Override
            public void intercept(Dot11ProbeResponseFrame frame) {
                if (frame.ssid() == null || frame.ssid().trim().isEmpty() || !Tools.isHumanlyReadable(frame.ssid())) {
                    return;
                }
                if (SentryInterceptorSet.this.unknownSSIDAlertEnabled && !SentryInterceptorSet.this.sentry.knowsSSID(frame.ssid())) {
                    SentryInterceptorSet.this.alerts.handle(UnknownSSIDAlert.create(DateTime.now(), frame.ssid(), frame.transmitter(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal()));
                }
                SentryInterceptorSet.this.sentry.tickSSID(frame.ssid(), DateTime.now());
            }

            @Override
            public byte forSubtype() {
                return 5;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(UnknownSSIDAlert.class);
                    }
                };
            }
        });
        return interceptors.build();
    }
}

