/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.ProbeRequestTrapResponseAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class ProbeRequestTrapResponseInterceptorSet {
    private final List<String> trappedSSIDs;
    private final AlertsService alerts;

    public ProbeRequestTrapResponseInterceptorSet(AlertsService alerts, List<String> trappedSSIDs) {
        this.alerts = alerts;
        this.trappedSSIDs = trappedSSIDs;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeResponseFrame>(){

            @Override
            public void intercept(Dot11ProbeResponseFrame frame) {
                if (frame.ssid() == null) {
                    return;
                }
                for (String ssid : ProbeRequestTrapResponseInterceptorSet.this.trappedSSIDs) {
                    if (!ssid.equals(frame.ssid())) continue;
                    ProbeRequestTrapResponseInterceptorSet.this.alerts.handle(ProbeRequestTrapResponseAlert.create(DateTime.now(), ssid, frame.transmitter(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L));
                }
            }

            @Override
            public byte forSubtype() {
                return 5;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(ProbeRequestTrapResponseAlert.class);
                    }
                };
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11BeaconFrame>(){

            @Override
            public void intercept(Dot11BeaconFrame frame) {
                if (frame.ssid() == null) {
                    return;
                }
                for (String ssid : ProbeRequestTrapResponseInterceptorSet.this.trappedSSIDs) {
                    if (!ssid.equals(frame.ssid())) continue;
                    ProbeRequestTrapResponseInterceptorSet.this.alerts.handle(ProbeRequestTrapResponseAlert.create(DateTime.now(), ssid, frame.transmitter(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L));
                }
            }

            @Override
            public byte forSubtype() {
                return 8;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(ProbeRequestTrapResponseAlert.class);
                    }
                };
            }
        });
        return interceptors.build();
    }
}

