/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.deauth.DeauthenticationMonitor;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DisassociationFrame;
import java.util.Collections;
import java.util.List;

public class DeauthFrameCounterInterceptorSet {
    private final DeauthenticationMonitor monitor;

    public DeauthFrameCounterInterceptorSet(DeauthenticationMonitor monitor) {
        this.monitor = monitor;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11DeauthenticationFrame>(){

            @Override
            public void intercept(Dot11DeauthenticationFrame frame) {
                DeauthFrameCounterInterceptorSet.this.monitor.record(frame);
            }

            @Override
            public byte forSubtype() {
                return 12;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.EMPTY_LIST;
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11DisassociationFrame>(){

            @Override
            public void intercept(Dot11DisassociationFrame frame) {
                DeauthFrameCounterInterceptorSet.this.monitor.record(frame);
            }

            @Override
            public byte forSubtype() {
                return 10;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.EMPTY_LIST;
            }
        });
        return interceptors.build();
    }
}

