/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.AutoValue_Dot11ProbeRequestFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import javax.annotation.Nullable;

@AutoValue
public abstract class Dot11ProbeRequestFrame
implements Dot11Frame {
    @Nullable
    public abstract String ssid();

    public abstract String requester();

    public abstract Boolean isBroadcastProbe();

    @Override
    public abstract Dot11MetaInformation meta();

    @Override
    public abstract byte[] payload();

    @Override
    public abstract byte[] header();

    @Override
    public abstract byte frameType();

    @JsonIgnore
    public String descriptionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE:         PROBE_REQUEST").append("\n");
        sb.append("SSID:         ").append(this.ssid()).append("\n");
        sb.append("Requester:    ").append(this.requester()).append("\n");
        sb.append("Is Broadcast: ").append(this.isBroadcastProbe()).append("\n");
        return sb.toString();
    }

    public static Dot11ProbeRequestFrame create(String requester, String ssid, Boolean isBroadcastProbe, Dot11MetaInformation meta, byte[] payload, byte[] header) {
        return Dot11ProbeRequestFrame.builder().requester(requester).ssid(ssid).isBroadcastProbe(isBroadcastProbe).meta(meta).payload(payload).header(header).frameType((byte)4).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11ProbeRequestFrame.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder requester(String var1);

        public abstract Builder ssid(String var1);

        public abstract Builder isBroadcastProbe(Boolean var1);

        public abstract Builder meta(Dot11MetaInformation var1);

        public abstract Builder payload(byte[] var1);

        public abstract Builder header(byte[] var1);

        public abstract Builder frameType(byte var1);

        public abstract Dot11ProbeRequestFrame build();
    }
}

