/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.codahale.metrics.MetricRegistry;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.dot11.parsers.Dot11AssociationRequestFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11AssociationResponseFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11AuthenticationFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11BeaconFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11DeauthenticationFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11DisassociationFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11ProbeRequestFrameParser;
import horse.wtf.nzyme.dot11.parsers.Dot11ProbeResponseFrameParser;
import horse.wtf.nzyme.remote.protobuf.NzymeMessage;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11FrameType;

public class Dot11FrameFactory {
    private final Dot11BeaconFrameParser beaconParser;
    private final Dot11AssociationRequestFrameParser associationRequestParser;
    private final Dot11AssociationResponseFrameParser associationResponseParser;
    private final Dot11ProbeRequestFrameParser probeRequestParser;
    private final Dot11ProbeResponseFrameParser probeResponseFrameParser;
    private final Dot11DisassociationFrameParser disassociationParser;
    private final Dot11AuthenticationFrameParser authenticationFrameParser;
    private final Dot11DeauthenticationFrameParser deauthenticationFrameParser;

    public Dot11FrameFactory(MetricRegistry metrics, Anonymizer anonymizer) {
        this.beaconParser = new Dot11BeaconFrameParser(metrics, anonymizer);
        this.associationRequestParser = new Dot11AssociationRequestFrameParser(metrics, anonymizer);
        this.associationResponseParser = new Dot11AssociationResponseFrameParser(metrics, anonymizer);
        this.probeRequestParser = new Dot11ProbeRequestFrameParser(metrics, anonymizer);
        this.probeResponseFrameParser = new Dot11ProbeResponseFrameParser(metrics, anonymizer);
        this.disassociationParser = new Dot11DisassociationFrameParser(metrics, anonymizer);
        this.authenticationFrameParser = new Dot11AuthenticationFrameParser(metrics, anonymizer);
        this.deauthenticationFrameParser = new Dot11DeauthenticationFrameParser(metrics, anonymizer);
    }

    public Dot11Frame build(Dot11FrameType type, byte[] payload, byte[] header, Dot11MetaInformation meta) throws MalformedFrameException, IllegalRawDataException {
        switch ((Byte)type.value()) {
            case 0: {
                return (Dot11Frame)this.associationRequestParser.parse(payload, header, meta);
            }
            case 1: {
                return (Dot11Frame)this.associationResponseParser.parse(payload, header, meta);
            }
            case 4: {
                return (Dot11Frame)this.probeRequestParser.parse(payload, header, meta);
            }
            case 5: {
                return (Dot11Frame)this.probeResponseFrameParser.parse(payload, header, meta);
            }
            case 8: {
                return (Dot11Frame)this.beaconParser.parse(payload, header, meta);
            }
            case 10: {
                return (Dot11Frame)this.disassociationParser.parse(payload, header, meta);
            }
            case 11: {
                return (Dot11Frame)this.authenticationFrameParser.parse(payload, header, meta);
            }
            case 12: {
                return (Dot11Frame)this.deauthenticationFrameParser.parse(payload, header, meta);
            }
        }
        throw new IllegalStateException("Unexpected value: " + type.value());
    }

    public Dot11Frame fromRemote(NzymeMessage.Dot11Frame frame) throws MalformedFrameException, IllegalRawDataException {
        Dot11FrameType type;
        switch (frame.getFrameType()) {
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11AssociationRequestFrame": {
                type = Dot11FrameType.ASSOCIATION_REQUEST;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11AssociationResponseFrame": {
                type = Dot11FrameType.ASSOCIATION_RESPONSE;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11AuthenticationFrame": {
                type = Dot11FrameType.AUTHENTICATION;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11BeaconFrame": {
                type = Dot11FrameType.BEACON;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11DeauthenticationFrame": {
                type = Dot11FrameType.DEAUTHENTICATION;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11DisassociationFrame": {
                type = Dot11FrameType.DISASSOCIATION;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11ProbeRequestFrame": {
                type = Dot11FrameType.PROBE_REQUEST;
                break;
            }
            case "horse.wtf.nzyme.dot11.frames.AutoValue_Dot11ProbeResponseFrame": {
                type = Dot11FrameType.PROBE_RESPONSE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown frame type [" + frame.getFrameType() + "].");
            }
        }
        NzymeMessage.FrameMeta meta = frame.getFrameMeta();
        return this.build(type, frame.getFramePayload().toByteArray(), frame.getFrameHeader().toByteArray(), new Dot11MetaInformation(meta.getIsMalformed(), meta.getAntennaSignal(), meta.getFrequency(), meta.getChannel(), meta.getMacTimestamp(), meta.getIsWEP()));
    }
}

