/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.AutoValue_Dot11DisassociationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;

@AutoValue
public abstract class Dot11DisassociationFrame
implements Dot11Frame {
    public abstract String destination();

    public abstract String transmitter();

    public abstract Short reasonCode();

    public abstract String reasonString();

    @Override
    public abstract Dot11MetaInformation meta();

    @Override
    public abstract byte[] payload();

    @Override
    public abstract byte[] header();

    @Override
    public abstract byte frameType();

    @JsonIgnore
    public String descriptionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE:          DISASSOCIATION").append("\n");
        sb.append("Transmitter:   ").append(this.transmitter()).append("\n");
        sb.append("Destination:   ").append(this.destination()).append("\n");
        sb.append("Reason Code:   ").append(this.reasonCode()).append("\n");
        sb.append("Reason String: ").append(this.reasonString()).append("\n");
        return sb.toString();
    }

    public static Dot11DisassociationFrame create(String destination, String transmitter, Short reasonCode, String reasonString, Dot11MetaInformation meta, byte[] payload, byte[] header) {
        return Dot11DisassociationFrame.builder().destination(destination).transmitter(transmitter).reasonCode(reasonCode).reasonString(reasonString).meta(meta).payload(payload).header(header).frameType((byte)10).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11DisassociationFrame.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder destination(String var1);

        public abstract Builder transmitter(String var1);

        public abstract Builder reasonCode(Short var1);

        public abstract Builder reasonString(String var1);

        public abstract Builder meta(Dot11MetaInformation var1);

        public abstract Builder payload(byte[] var1);

        public abstract Builder header(byte[] var1);

        public abstract Builder frameType(byte var1);

        public abstract Dot11DisassociationFrame build();
    }
}

