/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.database;

import horse.wtf.nzyme.alerts.service.AlertDatabaseEntryMapper;
import horse.wtf.nzyme.bandits.database.BanditIdentifierMapper;
import horse.wtf.nzyme.bandits.database.BanditMapper;
import horse.wtf.nzyme.bandits.database.ContactMapper;
import horse.wtf.nzyme.bandits.database.ContactRecordMapper;
import horse.wtf.nzyme.bandits.database.ContactRecordValueAggregationMapper;
import horse.wtf.nzyme.bandits.database.ContactRecorderHistogramEntryMapper;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.dot11.deauth.db.DeauthenticationMonitorRecordingMapper;
import horse.wtf.nzyme.dot11.networks.beaconrate.BeaconRateMapper;
import horse.wtf.nzyme.dot11.networks.sentry.db.SentrySSIDMapper;
import horse.wtf.nzyme.dot11.networks.signalstrength.SignalIndexHistogramHistoryDBEntryMapper;
import horse.wtf.nzyme.events.db.EventRecordMapper;
import horse.wtf.nzyme.measurements.mappers.MeasurementMapper;
import horse.wtf.nzyme.reporting.db.ExecutionLogEntryMapper;
import horse.wtf.nzyme.reporting.db.ScheduledReportEntryMapper;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.jodatime2.JodaTimePlugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class Database {
    public static final DateTimeFormatter DATABASE_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(new DateTimeFormatterBuilder().appendLiteral(".").appendFractionOfSecond(0, 6).toParser()).toFormatter().withZoneUTC();
    public static final DateTimeFormatter DEAUTH_MONITOR_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ssZ").toFormatter();
    public static final DateTimeFormatter BUCKET_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").toFormatter().withZoneUTC();
    private final LeaderConfiguration configuration;
    private Jdbi jdbi;

    public Database(LeaderConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeAndMigrate() throws LiquibaseException {
        this.jdbi = (Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)Jdbi.create("jdbc:" + this.configuration.databasePath()).installPlugin(new PostgresPlugin()).installPlugin(new JodaTimePlugin()).registerRowMapper(new MeasurementMapper())).registerRowMapper(new BeaconRateMapper())).registerRowMapper(new SignalIndexHistogramHistoryDBEntryMapper())).registerRowMapper(new AlertDatabaseEntryMapper())).registerRowMapper(new BanditMapper())).registerRowMapper(new BanditIdentifierMapper())).registerRowMapper(new ContactMapper())).registerRowMapper(new SentrySSIDMapper())).registerRowMapper(new DeauthenticationMonitorRecordingMapper())).registerRowMapper(new EventRecordMapper())).registerRowMapper(new ScheduledReportEntryMapper())).registerRowMapper(new ExecutionLogEntryMapper())).registerRowMapper(new ContactRecordMapper())).registerRowMapper(new ContactRecordValueAggregationMapper())).registerRowMapper(new ContactRecorderHistogramEntryMapper());
        try (JdbcConnection connection = new JdbcConnection(this.jdbi.open().getConnection());){
            liquibase.database.Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection);
            Liquibase liquibase = new Liquibase("db/migrations.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update(new Contexts(), new LabelExpression());
        }
    }

    public long getTotalSize() {
        return this.withHandle(handle -> handle.createQuery("SELECT pg_database_size(current_database())").mapTo(Long.class).first());
    }

    public <R, X extends Exception> R withHandle(HandleCallback<R, X> callback) throws X {
        return this.jdbi.withHandle(callback);
    }

    public <X extends Exception> void useHandle(HandleConsumer<X> callback) throws X {
        this.jdbi.useHandle(callback);
    }
}

