/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration.tracker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.bandits.trackers.devices.TrackerDevice;
import horse.wtf.nzyme.bandits.trackers.hid.TrackerHID;
import horse.wtf.nzyme.configuration.BaseDot11ConfigurationLoader;
import horse.wtf.nzyme.configuration.ConfigurationValidator;
import horse.wtf.nzyme.configuration.Dot11MonitorDefinition;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.configuration.UplinkDeviceConfiguration;
import horse.wtf.nzyme.configuration.tracker.TrackerConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class TrackerConfigurationLoader {
    private final Config root;
    private final Config general;
    private final Config uplinkDevice;
    private final BaseDot11ConfigurationLoader baseDot11ConfigurationLoader;

    public TrackerConfigurationLoader(File configFile) throws InvalidConfigurationException, IncompleteConfigurationException, FileNotFoundException {
        if (!Files.isReadable(configFile.toPath())) {
            throw new FileNotFoundException("File at [" + configFile.getPath() + "] does not exist or is not readable. Check path and permissions.");
        }
        this.root = ConfigFactory.parseFile(configFile).resolve();
        this.baseDot11ConfigurationLoader = new BaseDot11ConfigurationLoader(this.root);
        try {
            this.general = this.root.getConfig("general");
            this.uplinkDevice = this.root.getConfig("uplink_device");
        }
        catch (ConfigException e2) {
            throw new IncompleteConfigurationException("Incomplete configuration.", e2);
        }
        this.validate();
    }

    public TrackerConfiguration get() {
        return TrackerConfiguration.create(this.parseRole(), this.parseUplinkDevice(), this.parseHIDs(), this.baseDot11ConfigurationLoader.parseDot11Monitors());
    }

    private Role parseRole() {
        return this.general.getEnum(Role.class, "role");
    }

    private UplinkDeviceConfiguration parseUplinkDevice() {
        return UplinkDeviceConfiguration.create(this.uplinkDevice.getString("type"), this.uplinkDevice.getConfig("parameters"));
    }

    private List<TrackerHID.TYPE> parseHIDs() {
        ArrayList<TrackerHID.TYPE> hids = Lists.newArrayList();
        for (String hid : this.general.getStringList("hids")) {
            hids.add(TrackerHID.TYPE.valueOf(hid.toUpperCase()));
        }
        return hids;
    }

    private void validate() throws IncompleteConfigurationException, InvalidConfigurationException {
        ConfigurationValidator.expectEnum(this.general, "role", "general", Role.class);
        ConfigurationValidator.expect(this.general, "data_directory", "general", String.class);
        ConfigurationValidator.expect(this.root, "uplink_device", "<root>", Config.class);
        ConfigurationValidator.expect(this.general, "hids", "general", List.class);
        ConfigurationValidator.expect(this.uplinkDevice, "type", "uplink_device", String.class);
        ConfigurationValidator.expect(this.uplinkDevice, "parameters", "uplink_device", Config.class);
        ConfigurationValidator.expect(this.uplinkDevice, "type", "uplink_device", String.class);
        ConfigurationValidator.expect(this.uplinkDevice, "parameters", "uplink_device", Config.class);
        for (String hid : this.general.getStringList("hids")) {
            try {
                TrackerHID.TYPE.valueOf(hid.toUpperCase());
            }
            catch (Exception e2) {
                throw new InvalidConfigurationException("Invalid HID [" + hid + "] configured.", e2);
            }
        }
        if (this.uplinkDevice.getString("type").equals(TrackerDevice.TYPE.SX126X_LORA.toString())) {
            Config loraConfig = this.uplinkDevice.getConfig("parameters");
            ConfigurationValidator.expect(loraConfig, "serial_port", "uplink_device.parameters", String.class);
            String serialPortPath = loraConfig.getString("serial_port");
            if (!new File(serialPortPath).exists()) {
                throw new InvalidConfigurationException("Parameter uplink_device.parameters.serial_port does not point to an existing serial port path at [" + serialPortPath + "].");
            }
            ConfigurationValidator.expect(loraConfig, "encryption_key", "uplink_device.parameters", String.class);
            String encryptionKey = loraConfig.getString("encryption_key");
            if (encryptionKey.length() != 32) {
                throw new InvalidConfigurationException("Parameter uplink_device.parameters.encryption_key must be exactly 32 characters long.");
            }
        }
        this.baseDot11ConfigurationLoader.validateMonitors();
        ImmutableList<Dot11MonitorDefinition> monitors = this.baseDot11ConfigurationLoader.parseDot11Monitors();
        if (monitors.isEmpty()) {
            throw new IncompleteConfigurationException("No 802.11 monitors configured. The tracker needs at least one monitor to work. Configure in nzyme configuration file at [802_11_monitors].");
        }
    }
}

