/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration;

import com.beust.jcommander.internal.Lists;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import horse.wtf.nzyme.configuration.AutoValue_Dot11NetworkDefinition;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class Dot11NetworkDefinition {
    public abstract String ssid();

    public abstract List<Dot11BSSIDDefinition> bssids();

    public abstract List<Integer> channels();

    public abstract List<String> security();

    public abstract int beaconRate();

    @JsonIgnore
    public List<String> allBSSIDAddresses() {
        if (this.bssids() == null || this.bssids().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> addresses = Lists.newArrayList();
        for (Dot11BSSIDDefinition bssid : this.bssids()) {
            addresses.add(bssid.address());
        }
        return addresses;
    }

    public static Dot11NetworkDefinition create(String ssid, List<Dot11BSSIDDefinition> bssids, List<Integer> channels, List<String> security, int beaconRate) {
        return Dot11NetworkDefinition.builder().ssid(ssid).bssids(bssids).channels(channels).security(security).beaconRate(beaconRate).build();
    }

    @JsonIgnore
    public static boolean checkConfig(Config c2) {
        return !Strings.isNullOrEmpty(c2.getString("ssid")) && c2.getConfigList("bssids") != null && !c2.getConfigList("bssids").isEmpty() && c2.getIntList("channels") != null && !c2.getIntList("channels").isEmpty() && c2.getStringList("security") != null && c2.getInt("beacon_rate") >= 0;
    }

    public static Builder builder() {
        return new AutoValue_Dot11NetworkDefinition.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder ssid(String var1);

        public abstract Builder bssids(List<Dot11BSSIDDefinition> var1);

        public abstract Builder channels(List<Integer> var1);

        public abstract Builder security(List<String> var1);

        public abstract Builder beaconRate(int var1);

        public abstract Dot11NetworkDefinition build();
    }
}

