/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.channels;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeConfiguration;
import horse.wtf.nzyme.util.Tools;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelHopper {
    private static final Logger LOG = LogManager.getLogger(ChannelHopper.class);
    private final Dot11Probe probe;
    private final Dot11ProbeConfiguration probeConfiguration;
    private final List<ChannelSwitchHandler> channelSwitchHandlers;
    private List<Integer> configuredChannels;
    private int currentChannel = 0;
    private int currentChannelIndex = 0;

    public ChannelHopper(Dot11Probe probe, Dot11ProbeConfiguration probeConfiguration) {
        if (probeConfiguration.channels() == null || probeConfiguration.channels().isEmpty()) {
            throw new RuntimeException("Channels empty or NULL. You need to configure at least one channel.");
        }
        this.configuredChannels = probeConfiguration.channels();
        this.channelSwitchHandlers = Lists.newArrayList();
        this.probe = probe;
        this.probeConfiguration = probeConfiguration;
    }

    public void initialize() {
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("channel-hopper-%d").build()).scheduleWithFixedDelay(() -> {
            try {
                ArrayList<Integer> channels = new ArrayList<Integer>(this.configuredChannels);
                if (!this.probe.isInLoop()) {
                    LOG.debug("Not hopping channel. Probe [{}] not in loop.", (Object)this.probeConfiguration.networkInterfaceName());
                    return;
                }
                this.currentChannelIndex = this.currentChannelIndex >= channels.size() - 1 ? 0 : ++this.currentChannelIndex;
                int channel = (Integer)channels.get(this.currentChannelIndex);
                LOG.debug("Configuring [{}] to use channel <{}>", (Object)this.probeConfiguration.networkInterfaceName(), (Object)channel);
                this.changeToChannel(channel);
            }
            catch (Exception e2) {
                LOG.error("Could not hop channel.", (Throwable)e2);
            }
        }, 0L, this.probeConfiguration.channelHopInterval().intValue(), TimeUnit.SECONDS);
    }

    private void changeToChannel(Integer channel) {
        try {
            int previousChannel = this.currentChannel;
            String networkInterface = Tools.safeAlphanumericString(this.probeConfiguration.networkInterfaceName());
            String command = this.probeConfiguration.channelHopCommand().replace("{channel}", channel.toString()).replace("{interface}", networkInterface);
            LOG.debug("Executing: [{}]", (Object)command);
            Process exec = Runtime.getRuntime().exec(command);
            int returnCode = exec.waitFor();
            Object stderr = CharStreams.toString(new InputStreamReader(exec.getErrorStream())).replace("\n", "").replace("\r", "");
            if (returnCode != 0 || !((String)stderr).trim().isEmpty()) {
                if (((String)stderr).contains("no tty present and no askpass program specified")) {
                    stderr = (String)stderr + " (are you running with sudo? It must succeed without STDIN/user input. See README for instructions.)";
                }
                LOG.fatal("Could not configure interface [{}] to use channel <{}>. Return code <{}>, STDERR: [{}]", (Object)networkInterface, (Object)channel, (Object)returnCode, stderr);
            } else {
                this.currentChannel = channel;
                LOG.debug("Channel change successful.");
                for (ChannelSwitchHandler handler : this.channelSwitchHandlers) {
                    handler.handle(previousChannel, this.currentChannel);
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Could not hop to channel <{}>.", (Object)channel, (Object)e2);
        }
    }

    public void setChannels(List<Integer> channels) {
        if (channels.equals(this.configuredChannels)) {
            return;
        }
        LOG.info("Updating list of channels to <{}>.", (Object)Joiner.on(",").join(channels));
        this.configuredChannels = channels;
        this.currentChannel = 0;
        this.currentChannelIndex = 0;
    }

    public Integer getCurrentChannel() {
        return this.currentChannel;
    }

    public void onChannelSwitch(ChannelSwitchHandler handler) {
        this.channelSwitchHandlers.add(handler);
    }

    public static interface ChannelSwitchHandler {
        public void handle(int var1, int var2);
    }
}

