/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.hid.webhid.rest.resources;

import horse.wtf.nzyme.NzymeTracker;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.WebHID;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.rest.responses.StateResponse;
import horse.wtf.nzyme.rest.authentication.Secured;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/api/state")
@Secured
@Produces(value={"application/json"})
public class TrackerWebHIDResource {
    @Inject
    private NzymeTracker nzyme;
    @Inject
    private WebHID hid;

    @GET
    public Response getStatus() {
        Long banditSignal;
        DateTime lastContact;
        long frameCount;
        String track;
        if (this.nzyme.getBanditManager().hasActiveTrack() && this.nzyme.getBanditManager().getTrackSummary() != null) {
            track = this.nzyme.getBanditManager().getTrackSummary().track().toString().substring(0, 6);
            frameCount = this.nzyme.getBanditManager().getTrackSummary().frameCount();
            lastContact = this.nzyme.getBanditManager().getTrackSummary().lastContact();
            banditSignal = this.nzyme.getBanditManager().getTrackSummary().lastSignal();
        } else {
            track = null;
            frameCount = 0L;
            lastContact = null;
            banditSignal = null;
        }
        return Response.ok(StateResponse.create(DateTime.now(), this.nzyme.getStateWatchdog().getStates(), this.hid.getLeaderRSSI(), this.hid.isTrackerDeviceLive(), this.hid.isAllProbesLive(), this.hid.allMonitorChannels(), this.hid.getChannelDesignationStatus(), this.nzyme.getBanditManager().isCurrentlyTracking(), this.nzyme.getBanditManager().isCurrentlyTracking() ? this.nzyme.getBanditManager().getCurrentlyTrackedBandit().uuid().toString().substring(0, 6) : null, track, frameCount, lastContact, banditSignal, this.hid.getEvents())).build();
    }
}

