/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.hid.webhid.rest.resources;

import horse.wtf.nzyme.util.Tools;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;

@Path(value="/")
public class TrackerWebHIDAssetsResource {
    @GET
    public Response getPage(@Context ContainerRequest request, @Context HttpHeaders headers) {
        try {
            return Response.ok((Object)this.readFile("index.html"), "text/html").build();
        }
        catch (IOException e2) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/assets/favicon.ico")
    public Response getFavicon() {
        try {
            return Response.ok((Object)this.readFile("assets/favicon.ico"), "image/x-icon").build();
        }
        catch (IOException e2) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/assets/{filename}.css")
    public Response getCSS(@PathParam(value="filename") String filename) {
        try {
            return Response.ok((Object)this.readFile("assets/" + Tools.safeAlphanumericString(filename) + ".css"), "text/css").build();
        }
        catch (IOException e2) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/assets/{filename}.js")
    public Response getFont(@PathParam(value="filename") String filename) {
        try {
            return Response.ok((Object)this.readFile("assets/" + Tools.safeAlphanumericString(filename) + ".js"), "application/javascript").build();
        }
        catch (IOException e2) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/assets/{filename}.png")
    public Response getPNG(@PathParam(value="filename") String filename) {
        try {
            return Response.ok((Object)this.readFile("assets/" + Tools.safeAlphanumericString(filename) + ".png"), "image/javascript").build();
        }
        catch (IOException e2) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="/assets/fonts/{filename}.woff2")
    public Response getJS(@PathParam(value="filename") String filename) {
        try {
            return Response.ok((Object)this.readFile("assets/fonts/" + Tools.safeAlphanumericString(filename) + ".woff2"), "font/woff2").build();
        }
        catch (IOException e2) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }

    private byte[] readFile(String filename) throws IOException {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("trackerwebhid/" + filename);
        if (resource == null) {
            throw new RuntimeException("Couldn't find asset [trackerwebhid/" + filename + "].");
        }
        return resource.readAllBytes();
    }
}

