/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.hid;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.SimpleTheme;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.table.Table;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.DefaultTerminalFactory;
import com.googlecode.lanterna.terminal.Terminal;
import horse.wtf.nzyme.NzymeTracker;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.trackers.TrackerState;
import horse.wtf.nzyme.bandits.trackers.TrackerTrackSummary;
import horse.wtf.nzyme.bandits.trackers.hid.AutoValue_TextGUIHID_Event;
import horse.wtf.nzyme.bandits.trackers.hid.TrackerHID;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.dot11.probes.Dot11MonitorProbe;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class TextGUIHID
implements TrackerHID {
    private static final Logger LOG = LogManager.getLogger(TextGUIHID.class);
    private static final int COLS = 80;
    private static final int ROWS = 22;
    private final Label labelConnection = new Label(" DARK").setForegroundColor(TextColor.ANSI.RED);
    private final Label labelSignal = new Label(" ???").setForegroundColor(TextColor.ANSI.RED);
    private final Label labelTime = new Label("");
    private final Label labelTrackerStatus = new Label("");
    private final Label labelWiFiStatus = new Label("");
    private final Label labelWiFiChannels = new Label("").setForegroundColor(TextColor.ANSI.WHITE);
    private final Label labelDesignator = new Label("").setForegroundColor(TextColor.ANSI.WHITE);
    private final Label labelTask = new Label("");
    private final Label labelBandit = new Label("");
    private final Label labelTrack = new Label("");
    private final Label labelTrackSignal = new Label("");
    private final Label labelTrackFrames = new Label("");
    private final Label labelTrackContact = new Label("");
    private final Table<String> eventsTable = new Table("Timestamp", "Source", "Event");
    private final EvictingQueue<Event> events;
    private final NzymeTracker nzyme;

    public TextGUIHID(NzymeTracker nzyme) {
        this.nzyme = nzyme;
        this.events = EvictingQueue.create(5);
    }

    @Override
    public void initialize() {
        Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("textguihid-%d").build()).submit(() -> {
            try {
                Thread.sleep(5000L);
                this.initializeGUI();
            }
            catch (Exception e2) {
                LOG.error("Could not initialize Text GUI HID.", (Throwable)e2);
            }
        });
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("textguihid-secup-%d").build()).scheduleWithFixedDelay(() -> {
            this.labelTime.setText(DateTime.now().toString(DateTimeFormat.forPattern("HH:mm:ss")));
            this.labelWiFiChannels.setText(this.wifiChannels());
            boolean allProbesLive = true;
            Dot11MonitorProbe firstMonitor = null;
            for (Dot11Probe probe : this.nzyme.getProbes()) {
                if (probe.isInLoop() && probe.isActive()) continue;
                allProbesLive = false;
                break;
            }
            for (Dot11Probe probe : this.nzyme.getProbes()) {
                if (!(probe instanceof Dot11MonitorProbe)) continue;
                firstMonitor = (Dot11MonitorProbe)probe;
                break;
            }
            if (firstMonitor != null) {
                switch (firstMonitor.getChannelDesignator().getStatus()) {
                    case LOCKED: {
                        this.labelDesignator.setText("  LOCK  ");
                        this.labelDesignator.setForegroundColor(TextColor.ANSI.BLACK);
                        this.labelDesignator.setBackgroundColor(TextColor.ANSI.GREEN);
                        break;
                    }
                    case UNLOCKED: {
                        this.labelDesignator.setText("UNLOCKED");
                        this.labelDesignator.setForegroundColor(TextColor.ANSI.WHITE);
                        this.labelDesignator.setBackgroundColor(TextColor.ANSI.BLACK);
                        break;
                    }
                    case SWEEPING: {
                        this.labelDesignator.setText("SWEEPING");
                        this.labelDesignator.setForegroundColor(TextColor.ANSI.BLACK);
                        this.labelDesignator.setBackgroundColor(TextColor.ANSI.YELLOW);
                    }
                }
            }
            if (allProbesLive) {
                this.labelWiFiStatus.setText(" ONLINE");
                this.labelWiFiStatus.setForegroundColor(TextColor.ANSI.GREEN);
            } else {
                this.labelWiFiStatus.setText("  WARN");
                this.labelWiFiStatus.setForegroundColor(TextColor.ANSI.RED);
            }
            if (this.nzyme.getGroundStation().getTrackerDevice().isHealthy()) {
                this.labelTrackerStatus.setText("  ONLINE");
                this.labelTrackerStatus.setForegroundColor(TextColor.ANSI.GREEN);
            } else {
                this.labelTrackerStatus.setText("   WARN");
                this.labelTrackerStatus.setForegroundColor(TextColor.ANSI.RED);
            }
            if (!this.nzyme.getBanditManager().isCurrentlyTracking()) {
                this.labelTask.setText(" NONE ");
                this.labelTask.setForegroundColor(TextColor.ANSI.BLACK);
                this.labelTask.setBackgroundColor(TextColor.ANSI.WHITE);
                this.labelBandit.setText("     NONE");
                this.labelBandit.setForegroundColor(TextColor.ANSI.WHITE);
                this.labelTrack.setText("  N/A  ");
                this.labelTrack.setForegroundColor(TextColor.ANSI.WHITE);
                this.labelTrack.setBackgroundColor(TextColor.ANSI.BLACK);
                this.labelTrackSignal.setText("    N/A");
                this.labelTrackSignal.setForegroundColor(TextColor.ANSI.WHITE);
                this.labelTrackContact.setText("     N/A");
                this.labelTrackContact.setForegroundColor(TextColor.ANSI.WHITE);
                this.labelTrackFrames.setText("  N/A   ");
                this.labelTrackFrames.setForegroundColor(TextColor.ANSI.WHITE);
            } else {
                this.labelTask.setText(" TRCK ");
                this.labelTask.setForegroundColor(TextColor.ANSI.BLACK);
                this.labelTask.setBackgroundColor(TextColor.ANSI.GREEN);
                String banditId = this.nzyme.getBanditManager().getCurrentlyTrackedBandit().uuid().toString().substring(0, 6);
                this.labelBandit.setText(TextGUIHID.getCenterPadding(banditId, 14) + banditId);
                this.labelBandit.setForegroundColor(TextColor.ANSI.GREEN);
                if (this.nzyme.getBanditManager().hasActiveTrack()) {
                    this.labelTrack.setText("  ACT  ");
                    this.labelTrack.setForegroundColor(TextColor.ANSI.BLACK);
                    this.labelTrack.setBackgroundColor(TextColor.ANSI.GREEN);
                    TrackerTrackSummary track = this.nzyme.getBanditManager().getTrackSummary();
                    if (track != null) {
                        String sig = String.valueOf(track.lastSignal());
                        this.labelTrackSignal.setText(TextGUIHID.getCenterPadding(sig, 10) + sig);
                        this.labelTrackSignal.setForegroundColor(TextColor.ANSI.GREEN);
                        this.labelTrackContact.setText("   " + track.lastContact().toString(DateTimeFormat.forPattern("HH:mm:ss")));
                        this.labelTrackContact.setForegroundColor(TextColor.ANSI.WHITE);
                        if (track.frameCount() > 99999999L) {
                            this.labelTrackFrames.setText("  >100M ");
                        } else {
                            this.labelTrackFrames.setText(TextGUIHID.getCenterPadding(String.valueOf(track.frameCount()), 8) + track.frameCount());
                        }
                        this.labelTrackFrames.setForegroundColor(TextColor.ANSI.GREEN);
                    }
                } else {
                    this.labelTrack.setText("  N/A  ");
                    this.labelTrack.setForegroundColor(TextColor.ANSI.BLACK);
                    this.labelTrack.setBackgroundColor(TextColor.ANSI.RED);
                    this.labelTrackSignal.setText("    N/A");
                    this.labelTrackSignal.setForegroundColor(TextColor.ANSI.WHITE);
                    this.labelTrackContact.setText("     N/A");
                    this.labelTrackContact.setForegroundColor(TextColor.ANSI.WHITE);
                    this.labelTrackFrames.setText("  N/A   ");
                    this.labelTrackFrames.setForegroundColor(TextColor.ANSI.WHITE);
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void initializeGUI() throws IOException {
        Terminal terminal = new DefaultTerminalFactory().setInitialTerminalSize(new TerminalSize(80, 22)).createTerminal();
        TerminalScreen screen = new TerminalScreen(terminal);
        screen.startScreen();
        BasicWindow window = new BasicWindow();
        Panel mainPanel = new Panel();
        Panel statusPanel = new Panel(new GridLayout(8));
        statusPanel.addComponent(this.labelConnection.withBorder(Borders.singleLine("CONN")));
        statusPanel.addComponent(this.labelSignal.withBorder(Borders.singleLine("SIG")));
        statusPanel.addComponent(this.labelTrackerStatus.withBorder(Borders.singleLine("LINK DVC")));
        statusPanel.addComponent(this.labelWiFiStatus.withBorder(Borders.singleLine("802.11")));
        statusPanel.addComponent(this.labelWiFiChannels.withBorder(Borders.singleLine("CHANNEL")));
        statusPanel.addComponent(this.labelDesignator.withBorder(Borders.singleLine("DSGNTR")));
        statusPanel.addComponent(new EmptySpace(new TerminalSize(3, 3)));
        statusPanel.addComponent(this.labelTime.withBorder(Borders.singleLine("CLOCK")));
        mainPanel.addComponent(statusPanel);
        Panel taskPanel = new Panel(new GridLayout(6));
        taskPanel.addComponent(this.labelTask.withBorder(Borders.singleLine("TASK")));
        taskPanel.addComponent(this.labelBandit.withBorder(Borders.singleLine("BANDIT TARGET")));
        taskPanel.addComponent(this.labelTrack.withBorder(Borders.singleLine("TRACK")));
        taskPanel.addComponent(this.labelTrackSignal.withBorder(Borders.singleLine("TRACK SIG")));
        taskPanel.addComponent(this.labelTrackFrames.withBorder(Borders.singleLine("FRAMES")));
        taskPanel.addComponent(this.labelTrackContact.withBorder(Borders.singleLine("LAST CONTACT")));
        mainPanel.addComponent(taskPanel);
        Panel eventsPanel = new Panel(new GridLayout(1));
        eventsPanel.addComponent(this.eventsTable.withBorder(Borders.singleLine("EVENTS")));
        this.eventsTable.setCellSelection(false);
        this.eventsTable.setSelectedRow(-1);
        this.eventsTable.setVisibleRows(5);
        this.eventsTable.setSize(new TerminalSize(80, 8));
        this.event(this.nzyme.getNodeID(), "Initialized tracker.");
        mainPanel.addComponent(eventsPanel);
        window.setComponent(mainPanel);
        window.setTheme(SimpleTheme.makeTheme(true, TextColor.ANSI.WHITE, TextColor.ANSI.BLACK, TextColor.ANSI.BLACK, TextColor.ANSI.BLUE, TextColor.ANSI.WHITE, TextColor.ANSI.RED, TextColor.ANSI.RED));
        window.setHints(Arrays.asList(Window.Hint.CENTERED, Window.Hint.NO_DECORATIONS));
        MultiWindowTextGUI gui = new MultiWindowTextGUI(screen, new DefaultWindowManager(), new EmptySpace(TextColor.ANSI.BLACK));
        gui.addWindowAndWait(window);
    }

    @Override
    public void onConnectionStateChange(List<TrackerState> connectionState) {
        if (connectionState.contains((Object)TrackerState.ONLINE)) {
            this.labelConnection.setText("ONLINE");
            this.labelConnection.setForegroundColor(TextColor.ANSI.GREEN);
        } else {
            this.labelConnection.setText(" DARK");
            this.labelConnection.setForegroundColor(TextColor.ANSI.RED);
            this.labelSignal.setText(" n/a");
            this.labelSignal.setForegroundColor(TextColor.ANSI.RED);
        }
    }

    @Override
    public void onPingFromLeaderReceived(TrackerMessage.Ping ping, int rssi) {
        long percent = Math.round((double)rssi / 255.0 * 100.0);
        if (percent == 100L) {
            percent = 99L;
        }
        TextColor.ANSI color = percent >= 75L ? TextColor.ANSI.GREEN : (percent > 50L ? TextColor.ANSI.YELLOW : TextColor.ANSI.RED);
        this.labelSignal.setText(" " + percent + "%");
        this.labelSignal.setForegroundColor(color);
    }

    @Override
    public void onPingFromTrackerReceived(TrackerMessage.Ping ping, int rssi) {
    }

    @Override
    public void onStartTrackingRequestReceived(TrackerMessage.StartTrackRequest request) {
        this.event(request.getSource(), "Received request to track bandit.");
    }

    @Override
    public void onCancelTrackingRequestReceived(TrackerMessage.CancelTrackRequest request) {
        this.event(request.getSource(), "All bandit tracking canceled on leader request.");
    }

    @Override
    public void onInitialContactWithTrackedBandit(Bandit bandit) {
    }

    @Override
    public void onBanditTrace(Bandit bandit, int rssi) {
    }

    @Override
    public void onChannelSwitch(int previousChannel, int newChannel) {
    }

    private String wifiChannels() {
        ArrayList<Integer> channels = Lists.newArrayList();
        for (Dot11Probe probe : this.nzyme.getProbes()) {
            channels.add(probe.getCurrentChannel());
        }
        String s2 = Joiner.on(",").join(channels);
        return TextGUIHID.getCenterPadding(s2, 9) + s2;
    }

    private static String getCenterPadding(String string, int width) {
        StringBuilder padding = new StringBuilder();
        for (int i2 = 0; i2 < (width - string.length()) / 2; ++i2) {
            padding.append(" ");
        }
        return padding.toString();
    }

    private static String getRightPadding(String string, int width) {
        StringBuilder padding = new StringBuilder();
        for (int i2 = 0; i2 < width - string.length(); ++i2) {
            padding.append(" ");
        }
        return padding.toString();
    }

    private void event(String source2, String message) {
        this.events.add(Event.create(DateTime.now(), source2, message));
        ArrayList<Event> list = Lists.newArrayList(this.events);
        Collections.reverse(list);
        this.eventsTable.getTableModel().clear();
        for (Event event : list) {
            String paddedSource = event.source().length() > 15 ? event.source().substring(0, 15) : event.source();
            String paddedMessage = event.message().length() > 55 ? event.message().substring(0, 55) : event.message();
            this.eventsTable.getTableModel().addRow((String[])new String[]{event.timestamp().toString(DateTimeFormat.forPattern("HH:mm:ss")), paddedSource + TextGUIHID.getRightPadding(paddedSource, 15), paddedMessage + TextGUIHID.getRightPadding(paddedMessage, 55)});
        }
    }

    @AutoValue
    public static abstract class Event {
        public abstract DateTime timestamp();

        public abstract String source();

        public abstract String message();

        public static Event create(DateTime timestamp, String source2, String message) {
            return Event.builder().timestamp(timestamp).source(source2).message(message).build();
        }

        public static Builder builder() {
            return new AutoValue_TextGUIHID_Event.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder timestamp(DateTime var1);

            public abstract Builder source(String var1);

            public abstract Builder message(String var1);

            public abstract Event build();
        }
    }
}

