/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.devices;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.google.protobuf.InvalidProtocolBufferException;
import horse.wtf.nzyme.bandits.trackers.devices.TrackerDevice;
import horse.wtf.nzyme.bandits.trackers.messagehandlers.WrapperMessageHandler;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.security.transport.TransportEncryption;
import horse.wtf.nzyme.util.Tools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.crypto.AEADBadTagException;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SX126XLoRaHat
implements TrackerDevice {
    private static final Logger LOG = LogManager.getLogger(SX126XLoRaHat.class);
    private static final int BAUD = 2400;
    private static final short NULL_BYTE_SEQUENCE_COUNT = 3;
    private final String portName;
    private SerialPort serialPort;
    private WrapperMessageHandler messageHandler = null;
    TransportEncryption encryption;
    private final Counter rxCounter;
    private final Counter txCounter;
    private final Timer encryptionTimer;
    private boolean healthyReceive = false;
    private boolean healthyTransmit = false;

    public SX126XLoRaHat(String portName, String encryptionKey, Counter rxCounter, Counter txCounter, Timer encryptionTimer) {
        this.portName = portName;
        this.rxCounter = rxCounter;
        this.txCounter = txCounter;
        this.encryptionTimer = encryptionTimer;
        try {
            this.encryption = new TransportEncryption(encryptionKey);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not initialize transport encryption.", e2);
        }
    }

    @Override
    public void initialize() throws TrackerDevice.TrackerDeviceInitializationException {
        if (this.messageHandler == null) {
            throw new TrackerDevice.TrackerDeviceInitializationException("No message receiver registered.");
        }
        try {
            this.handle();
        }
        catch (SerialPortException e2) {
            throw new TrackerDevice.TrackerDeviceInitializationException("Could not connect to serial port.", e2);
        }
        LOG.info("Fully initialized [{}].", (Object)this.getTypeDescription());
    }

    @Override
    public void stop() {
        if (this.serialPort != null && this.serialPort.isOpened()) {
            try {
                this.serialPort.closePort();
            }
            catch (SerialPortException e2) {
                LOG.warn("Could not close serial port.", (Throwable)e2);
            }
        }
    }

    @Override
    public boolean isHealthy() {
        return this.serialPort != null && this.serialPort.isOpened() && this.healthyTransmit && this.healthyReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void readLoop() {
        buffer = new ByteArrayOutputStream();
        nulCount = 0;
        chunkByteCount = 0;
        block14: while (true) {
            try {
                while (true) lbl-1000:
                // 10 sources

                {
                    b = this.handle().readBytes(1);
                    this.healthyReceive = true;
                    if (b == null) {
                        nulCount = 0;
                        buffer.reset();
                        continue;
                    }
                    if ((chunkByteCount = (int)((short)(chunkByteCount + 1))) == 241) {
                        chunkByteCount = 0;
                        continue;
                    }
                    if (b[0] == 0) {
                        if ((nulCount = (int)((short)(nulCount + 1))) != 3) continue;
                        try {
                            message = buffer.toByteArray();
                            rssiChunk = this.handle().readBytes(1);
                            if (rssiChunk == null || rssiChunk.length != 1) ** GOTO lbl-1000
                            rssi = rssiChunk[0] & 255;
                            SX126XLoRaHat.LOG.debug("Received <{}> bytes: {}", (Object)message.length, (Object)Tools.byteArrayToHexPrettyPrint(message));
                            decrypted = this.encryption.decrypt(message);
                            this.messageHandler.handle(TrackerMessage.Wrapper.parseFrom(decrypted), rssi);
                            this.rxCounter.inc(decrypted.length);
                        }
                        catch (AEADBadTagException e) {
                            SX126XLoRaHat.LOG.debug("Skipping invalid message. Payload was: [{}]", (Object)Tools.byteArrayToHexPrettyPrint(buffer.toByteArray()), (Object)e);
                        }
                        catch (InvalidProtocolBufferException e) {
                            SX126XLoRaHat.LOG.debug("Skipping invalid protobuf message. Payload was: [{}]", (Object)Tools.byteArrayToHexPrettyPrint(buffer.toByteArray()), (Object)e);
                        }
                        finally {
                            nulCount = 0;
                            chunkByteCount = 0;
                            buffer.reset();
                        }
                        continue;
                    }
                    if (nulCount > 0) {
                        for (i = 0; i < nulCount; ++i) {
                            buffer.write(0);
                        }
                        nulCount = 0;
                    }
                    try {
                        buffer.write(b);
                        continue block14;
                    }
                    catch (IOException e) {
                        SX126XLoRaHat.LOG.warn("Could not write to buffer.", (Throwable)e);
                        buffer.reset();
                        nulCount = 0;
                        chunkByteCount = 0;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                SX126XLoRaHat.LOG.warn("Error in read loop.", (Throwable)e);
                this.healthyReceive = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException var5_11) {
                }
                continue;
            }
            break;
        }
    }

    private SerialPort handle() throws SerialPortException {
        if (this.serialPort == null || !this.serialPort.isOpened()) {
            this.serialPort = new SerialPort(this.portName);
            this.serialPort.openPort();
            this.serialPort.setParams(2400, 8, 1, 0);
        }
        return this.serialPort;
    }

    @Override
    public String getTypeDescription() {
        return "Waveshare SX126X LoRa HAT";
    }

    @Override
    public synchronized void transmit(byte[] message) {
        try {
            ByteArrayOutputStream payload = new ByteArrayOutputStream();
            Timer.Context time = this.encryptionTimer.time();
            byte[] encrypted = this.encryption.encrypt(message);
            time.stop();
            LOG.debug("Sending payload: {}", (Object)Tools.byteArrayToHexPrettyPrint(encrypted));
            payload.write(encrypted);
            for (int i2 = 0; i2 < 3; i2 = (int)((short)(i2 + 1))) {
                payload.write(0);
            }
            byte[] buf = payload.toByteArray();
            LOG.debug("Transmitting <{}> bytes: {}", (Object)buf.length, (Object)Tools.byteArrayToHexPrettyPrint(buf));
            this.handle().writeBytes(buf);
            this.txCounter.inc(buf.length);
            this.healthyTransmit = true;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e2) {
            LOG.error("Could not transmit message.", (Throwable)e2);
            this.healthyTransmit = false;
        }
    }

    @Override
    public void onMessageReceived(WrapperMessageHandler receiver) {
        this.messageHandler = receiver;
    }
}

