/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.GeneratedMessageV3;
import com.typesafe.config.ConfigException;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.engine.ContactIdentifierProcess;
import horse.wtf.nzyme.bandits.trackers.Tracker;
import horse.wtf.nzyme.bandits.trackers.TrackerManager;
import horse.wtf.nzyme.bandits.trackers.TrackerState;
import horse.wtf.nzyme.bandits.trackers.devices.SX126XLoRaHat;
import horse.wtf.nzyme.bandits.trackers.devices.TrackerDevice;
import horse.wtf.nzyme.bandits.trackers.hid.TrackerHID;
import horse.wtf.nzyme.bandits.trackers.messagehandlers.CancelTrackRequestMessageHandler;
import horse.wtf.nzyme.bandits.trackers.messagehandlers.ContactStatusMessageHandler;
import horse.wtf.nzyme.bandits.trackers.messagehandlers.PingMessageHandler;
import horse.wtf.nzyme.bandits.trackers.messagehandlers.StartTrackRequestMessageHandler;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.configuration.UplinkDeviceConfiguration;
import horse.wtf.nzyme.util.MetricNames;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroundStation
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(GroundStation.class);
    private final TrackerDevice trackerDevice;
    private final Deque<byte[]> transmitQueue = new ArrayDeque<byte[]>(100);
    private PingMessageHandler pingHandler;
    private StartTrackRequestMessageHandler startTrackRequestMessageHandler;
    private CancelTrackRequestMessageHandler cancelTrackRequestMessageHandler;
    private ContactStatusMessageHandler contactStatusMessageHandler;
    private List<TrackerMessage.StartTrackRequest> pendingStartBanditTrackRequests;
    private List<TrackerMessage.CancelTrackRequest> pendingCancelBanditTrackRequests;
    private final List<TrackerHID> hids = Lists.newArrayList();
    private final Counter rxCounter;
    private final Counter txCounter;
    private final Timer encryptionTimer;

    public GroundStation(Role nzymeRole, String nzymeId, String nzymeVersion, MetricRegistry metrics, ContactIdentifierProcess contacts, @Nullable TrackerManager trackerManager, UplinkDeviceConfiguration config) throws ConfigException {
        TrackerDevice.TYPE deviceType;
        this.rxCounter = metrics.counter(MetricNames.GROUNDSTATION_RX);
        this.txCounter = metrics.counter(MetricNames.GROUNDSTATION_TX);
        this.encryptionTimer = metrics.timer(MetricNames.GROUNDSTATION_ENCRYPTION_TIMING);
        metrics.register(MetricNames.GROUNDSTATION_QUEUE_SIZE, this.transmitQueue::size);
        this.pendingStartBanditTrackRequests = Lists.newArrayList();
        this.pendingCancelBanditTrackRequests = Lists.newArrayList();
        try {
            deviceType = TrackerDevice.TYPE.valueOf(config.type());
        }
        catch (IllegalArgumentException e2) {
            throw new ConfigException.BadValue("type", "Invalid tracker device type.", (Throwable)e2);
        }
        switch (deviceType) {
            case SX126X_LORA: {
                this.trackerDevice = new SX126XLoRaHat(config.parameters().getString("serial_port"), config.parameters().getString("encryption_key"), this.rxCounter, this.txCounter, this.encryptionTimer);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected device type: " + deviceType);
            }
        }
        this.trackerDevice.onMessageReceived((message, rssi) -> {
            GeneratedMessageV3 request;
            if (message.hasPing()) {
                if (this.pingHandler != null) {
                    this.pingHandler.handle(message.getPing(), rssi);
                }
                for (TrackerHID hid : this.hids) {
                    switch (message.getPing().getNodeType()) {
                        case LEADER: {
                            hid.onPingFromLeaderReceived(message.getPing(), rssi);
                            break;
                        }
                        case TRACKER: {
                            hid.onPingFromTrackerReceived(message.getPing(), rssi);
                            break;
                        }
                    }
                }
            }
            if (message.hasStartTrackRequest()) {
                request = message.getStartTrackRequest();
                if (!((TrackerMessage.StartTrackRequest)request).getReceiver().equals(nzymeId)) {
                    LOG.debug("Ignoring start tracking request for other tracker [{}].", (Object)((TrackerMessage.StartTrackRequest)request).getReceiver());
                    return;
                }
                if (this.startTrackRequestMessageHandler != null) {
                    this.startTrackRequestMessageHandler.handle(message.getStartTrackRequest());
                }
                for (TrackerHID hid : this.hids) {
                    hid.onStartTrackingRequestReceived(message.getStartTrackRequest());
                }
            }
            if (message.hasCancelTrackRequest()) {
                request = message.getCancelTrackRequest();
                if (!((TrackerMessage.CancelTrackRequest)request).getReceiver().equals(nzymeId)) {
                    LOG.debug("Ignoring cancel tracking request for other tracker [{}].", (Object)((TrackerMessage.CancelTrackRequest)request).getReceiver());
                    return;
                }
                if (this.cancelTrackRequestMessageHandler != null) {
                    this.cancelTrackRequestMessageHandler.handle(message.getCancelTrackRequest());
                }
                for (TrackerHID hid : this.hids) {
                    hid.onCancelTrackingRequestReceived(message.getCancelTrackRequest());
                }
            }
            if (message.hasContactStatus() && this.contactStatusMessageHandler != null) {
                this.contactStatusMessageHandler.handle(message.getContactStatus());
            }
        });
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("groundstation-pings-%d").build()).scheduleAtFixedRate(() -> {
            try {
                String currentlyTrackedBandit = "";
                if (nzymeRole == Role.TRACKER) {
                    Bandit tracked = contacts.getCurrentlyTrackedBandit();
                    currentlyTrackedBandit = tracked == null ? "" : tracked.uuid().toString();
                }
                this.transmit(TrackerMessage.Wrapper.newBuilder().setPing(TrackerMessage.Ping.newBuilder().setSource(nzymeId).setVersion(nzymeVersion).setNodeType(TrackerMessage.Ping.NodeType.valueOf(nzymeRole.toString().toUpperCase())).setTrackingMode(currentlyTrackedBandit).build()).build());
            }
            catch (Exception e2) {
                LOG.error("Could not send Ground Station ping.", (Throwable)e2);
            }
        }, 0L, 5L, TimeUnit.SECONDS);
        if (nzymeRole == Role.LEADER) {
            Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("groundstation-track-requests-%d").build()).scheduleAtFixedRate(() -> {
                try {
                    for (TrackerMessage.StartTrackRequest banditTrackRequest : Lists.newArrayList(this.pendingStartBanditTrackRequests)) {
                        LOG.debug("Sending start track request for [{}] to [{}]", (Object)banditTrackRequest.getUuid(), (Object)banditTrackRequest.getReceiver());
                        this.transmit(TrackerMessage.Wrapper.newBuilder().setStartTrackRequest(banditTrackRequest).build());
                    }
                    for (TrackerMessage.CancelTrackRequest cancelTrackRequest : Lists.newArrayList(this.pendingCancelBanditTrackRequests)) {
                        LOG.debug("Sending cancel track requests to [{}].", (Object)cancelTrackRequest.getReceiver());
                        this.transmit(TrackerMessage.Wrapper.newBuilder().setCancelTrackRequest(cancelTrackRequest).build());
                    }
                    if (trackerManager != null) {
                        Tracker tracker;
                        ArrayList<TrackerMessage.StartTrackRequest> newStartTrackRequests = Lists.newArrayList();
                        ArrayList<TrackerMessage.CancelTrackRequest> newCancelTrackRequests = Lists.newArrayList();
                        for (TrackerMessage.StartTrackRequest startTrackRequest : new ArrayList<TrackerMessage.StartTrackRequest>(this.pendingStartBanditTrackRequests)) {
                            tracker = trackerManager.getTrackers().get(startTrackRequest.getReceiver());
                            if (tracker == null || TrackerManager.decideTrackerState(tracker).equals((Object)TrackerState.DARK)) {
                                LOG.info("Removing start bandit track request for [{}] from list of outstanding requests. Reason: Tracker has disappeared.", (Object)startTrackRequest.getReceiver());
                                continue;
                            }
                            if (!startTrackRequest.getUuid().equals(tracker.getTrackingMode())) {
                                newStartTrackRequests.add(startTrackRequest);
                                continue;
                            }
                            LOG.info("Removing start bandit track request for [{}] from list of outstanding requests. Reason: Tracker has confirmed receipt.", (Object)startTrackRequest.getReceiver());
                        }
                        for (TrackerMessage.CancelTrackRequest cancelTrackRequest : new ArrayList<TrackerMessage.CancelTrackRequest>(this.pendingCancelBanditTrackRequests)) {
                            tracker = trackerManager.getTrackers().get(cancelTrackRequest.getReceiver());
                            if (tracker == null || TrackerManager.decideTrackerState(tracker).equals((Object)TrackerState.DARK)) {
                                LOG.info("Removing cancel bandit track request for [{}] from list of outstanding requests. Reason: Tracker has disappeared.", (Object)cancelTrackRequest.getReceiver());
                                continue;
                            }
                            if (tracker.getTrackingMode() != null && !tracker.getTrackingMode().isEmpty()) {
                                newCancelTrackRequests.add(cancelTrackRequest);
                                continue;
                            }
                            LOG.info("Removing cancel bandit track request for [{}] from list of outstanding requests. Reason: Tracker has confirmed receipt.", (Object)cancelTrackRequest.getReceiver());
                        }
                        this.pendingStartBanditTrackRequests = newStartTrackRequests;
                        this.pendingCancelBanditTrackRequests = newCancelTrackRequests;
                    }
                }
                catch (Exception e2) {
                    LOG.error("Could not send track request.", (Throwable)e2);
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        }
        Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("groundstation-listener-%d").build()).submit(this.trackerDevice::readLoop);
        LOG.info("Ground Station is online.");
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (this.transmitQueue.peek() != null) {
                    this.trackerDevice.transmit(this.transmitQueue.poll());
                }
            }
            catch (Exception e2) {
                LOG.error("Could not transmit message to trackers.", (Throwable)e2);
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void stop() {
        this.trackerDevice.stop();
    }

    public TrackerDevice getTrackerDevice() {
        return this.trackerDevice;
    }

    public void transmit(@NotNull TrackerMessage.Wrapper message) {
        if (this.transmitQueue.size() > 5) {
            LOG.warn("Transmit queue size is unusually large at <{}> entries.", (Object)this.transmitQueue.size());
        }
        this.transmitQueue.addLast(message.toByteArray());
    }

    public void startTrackRequest(TrackerMessage.StartTrackRequest newRequest) {
        for (TrackerMessage.StartTrackRequest request : Lists.newArrayList(this.pendingStartBanditTrackRequests)) {
            if (!request.getReceiver().equals(newRequest.getReceiver()) || !request.getUuid().equals(newRequest.getUuid())) continue;
            return;
        }
        LOG.info("Sending START tracking request to tracker [{}] for bandit [{}].", (Object)newRequest.getReceiver(), (Object)newRequest.getUuid());
        this.pendingStartBanditTrackRequests.add(newRequest);
    }

    public void cancelTrackRequest(TrackerMessage.CancelTrackRequest cancelRequest) {
        ArrayList<TrackerMessage.StartTrackRequest> newRequests = Lists.newArrayList();
        for (TrackerMessage.StartTrackRequest request : Lists.newArrayList(this.pendingStartBanditTrackRequests)) {
            if (request.getReceiver().equals(cancelRequest.getReceiver())) continue;
            newRequests.add(request);
        }
        this.pendingStartBanditTrackRequests = newRequests;
        LOG.info("Sending STOP tracking request to tracker [{}].", (Object)cancelRequest.getReceiver());
        this.pendingCancelBanditTrackRequests.add(cancelRequest);
    }

    public void onPingReceived(PingMessageHandler pingHandler) {
        this.pingHandler = pingHandler;
    }

    public void onStartTrackRequestReceived(StartTrackRequestMessageHandler startTrackRequestMessageHandler) {
        this.startTrackRequestMessageHandler = startTrackRequestMessageHandler;
    }

    public void onCancelTrackRequestReceived(CancelTrackRequestMessageHandler cancelTrackRequestMessageHandler) {
        this.cancelTrackRequestMessageHandler = cancelTrackRequestMessageHandler;
    }

    public void onContactStatusReceived(ContactStatusMessageHandler contactStatusMessageHandler) {
        this.contactStatusMessageHandler = contactStatusMessageHandler;
    }

    public void handleTrackerConnectionStateChange(List<TrackerState> states) {
        for (TrackerHID hid : this.hids) {
            hid.onConnectionStateChange(states);
        }
    }

    public void registerHID(TrackerHID hid) {
        this.hids.add(hid);
    }

    public boolean trackerHasPendingStartTrackingRequest(String trackerName) {
        for (TrackerMessage.StartTrackRequest outstandingRequest : new ArrayList<TrackerMessage.StartTrackRequest>(this.pendingStartBanditTrackRequests)) {
            if (!outstandingRequest.getReceiver().equals(trackerName)) continue;
            return true;
        }
        return false;
    }

    public boolean trackerHasPendingCancelTrackingRequest(String trackerName) {
        for (TrackerMessage.CancelTrackRequest outstandingRequest : new ArrayList<TrackerMessage.CancelTrackRequest>(this.pendingCancelBanditTrackRequests)) {
            if (!outstandingRequest.getReceiver().equals(trackerName)) continue;
            return true;
        }
        return false;
    }

    public boolean trackerHasPendingAnyTrackingRequest(String trackerName) {
        return this.trackerHasPendingStartTrackingRequest(trackerName) || this.trackerHasPendingCancelTrackingRequest(trackerName);
    }
}

