/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.identifiers;

import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierDescriptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class SSIDIBanditdentifier
extends BanditIdentifier {
    private final List<String> ssids;
    private final String listDescription;

    public SSIDIBanditdentifier(List<String> ssids, Long databaseID, UUID uuid) {
        super(databaseID, uuid, BanditIdentifier.TYPE.SSID);
        this.ssids = ssids;
        this.listDescription = ssids.stream().map(s2 -> "\"" + s2 + "\"").collect(Collectors.joining(","));
    }

    @Override
    public BanditIdentifierDescriptor descriptor() {
        return BanditIdentifierDescriptor.create(BanditIdentifier.TYPE.SSID, "Matches if the SSID advertised by frame is one of the configured SSIDs. (multiple SSIDs can be entered, separated by comma)", "frame.ssid IN [" + this.listDescription + "]");
    }

    @Override
    public Map<String, Object> configuration() {
        return new HashMap<String, Object>(){
            {
                this.put("ssids", SSIDIBanditdentifier.this.ssids);
            }
        };
    }

    @Override
    public Optional<Boolean> matches(Dot11DeauthenticationFrame frame) {
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> matches(Dot11BeaconFrame frame) {
        return this.match(frame.ssid());
    }

    @Override
    public Optional<Boolean> matches(Dot11ProbeResponseFrame frame) {
        return this.match(frame.ssid());
    }

    private Optional<Boolean> match(String ssid) {
        return Optional.of(this.ssids.contains(ssid));
    }
}

