/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.identifiers;

import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.FingerprintBanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.PwnagotchiBanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.SSIDIBanditdentifier;
import horse.wtf.nzyme.bandits.identifiers.SignalStrengthBanditIdentifier;
import horse.wtf.nzyme.util.Tools;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public class BanditIdentifierFactory {
    public static BanditIdentifier create(BanditIdentifier.TYPE type, Map<String, Object> config, @Nullable Long databaseID, UUID uuid) throws NoSerializerException, MappingException {
        switch (type) {
            case FINGERPRINT: {
                if (!config.containsKey("fingerprint")) {
                    throw new MappingException(config.toString());
                }
                try {
                    return new FingerprintBanditIdentifier((String)config.get("fingerprint"), databaseID, uuid);
                }
                catch (Exception e2) {
                    throw new MappingException(config.toString(), e2);
                }
            }
            case SSID: {
                if (!config.containsKey("ssids")) {
                    throw new MappingException(config.toString());
                }
                try {
                    return new SSIDIBanditdentifier((List)config.get("ssids"), databaseID, uuid);
                }
                catch (Exception e3) {
                    throw new MappingException(config.toString(), e3);
                }
            }
            case SIGNAL_STRENGTH: {
                if (!config.containsKey("from") || !config.containsKey("to")) {
                    throw new MappingException(config.toString());
                }
                try {
                    return new SignalStrengthBanditIdentifier(Tools.getInteger(config.get("from")), Tools.getInteger(config.get("to")), databaseID, uuid);
                }
                catch (Exception e4) {
                    throw new MappingException(config.toString(), e4);
                }
            }
            case PWNAGOTCHI_IDENTITY: {
                if (!config.containsKey("identity")) {
                    throw new MappingException(config.toString());
                }
                try {
                    return new PwnagotchiBanditIdentifier((String)config.get("identity"), databaseID, uuid);
                }
                catch (Exception e5) {
                    throw new MappingException(config.toString(), e5);
                }
            }
        }
        throw new NoSerializerException();
    }

    public static class MappingException
    extends Exception {
        public MappingException(String msg) {
            super(msg);
        }

        public MappingException(String msg, Throwable e2) {
            super(msg, e2);
        }
    }

    public static class NoSerializerException
    extends Exception {
    }
}

