/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class UnexpectedFingerprintProbeRespAlert
extends Alert {
    private static final String DESCRIPTION = "One of our stations is replying to devices that are looking for known access points (probing) with a fingerprint that is not in the list of configured expected fingerprints. This could indicate that a possible attacker is spoofing your network.";
    private static final String DOC_LINK = "guidance-UNEXPECTED_FINGERPRINT";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A legitimate change of the access point configuration took place and the nzyme configuration has not been updated.");
        }
    };

    private UnexpectedFingerprintProbeRespAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "SSID [" + this.getSSID() + "] was advertised with a probe response by a device with unexpected fingerprint [" + this.getFingerprint() + "]";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.UNEXPECTED_FINGERPRINT_PROBERESP;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    public String getFingerprint() {
        return (String)this.getFields().get("bandit_fingerprint");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof UnexpectedFingerprintProbeRespAlert)) {
            return false;
        }
        UnexpectedFingerprintProbeRespAlert a2 = (UnexpectedFingerprintProbeRespAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getFingerprint().equals(this.getFingerprint());
    }

    public static UnexpectedFingerprintProbeRespAlert create(DateTime firstSeen, @NotNull String ssid, String fingerprint, String bssid, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        if (Strings.isNullOrEmpty(fingerprint)) {
            throw new IllegalArgumentException("This alert cannot be raised for empty fingerprints.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("bssid", bssid.toLowerCase());
        fields.put("ssid", ssid);
        fields.put("bandit_fingerprint", fingerprint);
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new UnexpectedFingerprintProbeRespAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

