/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class UnexpectedChannelProbeRespAlert
extends Alert {
    private static final String DESCRIPTION = "One of our stations is replying to devices that are looking for known access points (probing) on a channel that is not in the list of configured expected channels. This could indicate that a possible attacker is not careful enough and does not limit spoofing to channels that are in use by the legitimate access points.";
    private static final String DOC_LINK = "guidance-UNEXPECTED_CHANNEL";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A legitimate change of the access point configuration took place and the nzyme configuration has not been updated.");
            this.add("Some access points will dynamically choose channels based on RF spectrum congestion. Always include all possibly used channels in the nzyme configuration.");
        }
    };

    private UnexpectedChannelProbeRespAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "SSID [" + this.getSSID() + "] was advertised with a probe response frame on an unexpected channel.";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.UNEXPECTED_CHANNEL_PROBERESP;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public int getChannel() {
        return (Integer)this.getFields().get("channel");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof UnexpectedChannelProbeRespAlert)) {
            return false;
        }
        UnexpectedChannelProbeRespAlert a2 = (UnexpectedChannelProbeRespAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getChannel() == this.getChannel();
    }

    public static UnexpectedChannelProbeRespAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new UnexpectedChannelProbeRespAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

